package com.atlassian.crowd.model.permission;


import com.atlassian.crowd.manager.permission.PermittedGroup;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.google.common.base.MoreObjects;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class InternalGrantedPermission implements Serializable, PermittedGroup {
    private Long id;
    private UserPermission permission;
    private Date createdDate;

    private DirectoryMapping directoryMapping;
    private String groupName;

    @SuppressWarnings("unused")
    private InternalGrantedPermission() {
    }

    public InternalGrantedPermission(Long id, Date createdDate, UserPermission userPermission, DirectoryMapping directoryMapping, String groupName) {
        this.id = id;
        this.createdDate = createdDate;
        this.permission = userPermission;
        this.directoryMapping = directoryMapping;
        this.groupName = groupName;
    }

    public InternalGrantedPermission(UserPermission userPermission, DirectoryMapping directoryMapping, String groupName) {
        this(null, null, userPermission, directoryMapping, groupName);
    }

    public Long getId() {
        return id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public Date getCreatedDate() {
        return createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public UserPermission getPermission() {
        return permission;
    }

    public void setPermission(UserPermission permission) {
        this.permission = permission;
    }

    @Override
    public Long getDirectoryId() {
        return directoryMapping.getDirectory().getId();
    }

    @Override
    public String getDirectoryName() {
        return directoryMapping.getDirectory().getName();
    }

    @Override
    public String getGroupName() {
        return groupName;
    }

    private void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public DirectoryMapping getDirectoryMapping() {
        return directoryMapping;
    }

    private void setDirectoryMapping(DirectoryMapping directoryMapping) {
        this.directoryMapping = directoryMapping;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", id)
                .add("permission", permission)
                .add("createdDate", createdDate)
                .add("directoryMapping", directoryMapping)
                .add("groupName", groupName)
                .toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InternalGrantedPermission that = (InternalGrantedPermission) o;
        return Objects.equals(id, that.id) &&
                permission == that.permission &&
                Objects.equals(createdDate, that.createdDate) &&
                Objects.equals(directoryMapping, that.directoryMapping) &&
                Objects.equals(groupName, that.groupName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, permission, createdDate, directoryMapping, groupName);
    }
}
