package com.atlassian.crowd.manager.permission;


import com.atlassian.crowd.model.permission.UserPermission;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * Convenience implementation (non persisted) to return to the service layer
 */
public class PermittedGroupImpl extends DirectoryGroupImpl implements PermittedGroup {
    private final UserPermission permission;

    public PermittedGroupImpl(UserPermission permission, Long directoryId, String directoryName, String groupName) {
        super(directoryId, directoryName, groupName);
        this.permission = permission;
    }

    public UserPermission getPermission() {
        return permission;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("directoryId", getDirectoryId())
                .append("directoryName", getDirectoryName())
                .append("groupName", getGroupName())
                .append("permission", permission).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PermittedGroupImpl that = (PermittedGroupImpl) o;

        if (getDirectoryId() != null ? !getDirectoryId().equals(that.getDirectoryId()) : that.getDirectoryId() != null)
            return false;
        if (getDirectoryName() != null ? !getDirectoryName().equals(that.getDirectoryName()) : that.getDirectoryName() != null)
            return false;
        if (getGroupName() != null ? !getGroupName().equals(that.getGroupName()) : that.getGroupName() != null)
            return false;
        if (permission != null ? !permission.equals(that.permission) : that.permission != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = getDirectoryId() != null ? getDirectoryId().hashCode() : 0;
        result = 31 * result + (getDirectoryName() != null ? getDirectoryName().hashCode() : 0);
        result = 31 * result + (getGroupName() != null ? getGroupName().hashCode() : 0);
        result = 31 * result + (permission != null ? permission.hashCode() : 0);
        return result;
    }
}
