package com.atlassian.crowd.dao.sso;

import com.atlassian.crowd.model.sso.idp.SAMLTrustEntity;

import java.util.List;
import java.util.Optional;

/**
 * Allows storing and retrieving SAML trust entities (certificates and private keys in PEM format)
 */
public interface SAMLTrustDAO {
    /**
     * Store new certificate and private key
     * @param samlTrustEntity trust entity (certificate and private key) to store
     * @return the newly-persisted SAML trust entity
     */
    SAMLTrustEntity addSamlTrustEntity(SAMLTrustEntity samlTrustEntity);

    /**
     * @param trustEntityId the id of the trust entity (certificate and private key) to find
     * @return trust entity based on passed id if found, none otherwise
     */
    Optional<SAMLTrustEntity> findSamlTrustEntityById(long trustEntityId);

    /**
     * Returns all stored entities of type {@link SAMLTrustEntity}.
     */
    List<SAMLTrustEntity> findAll();
}