package com.atlassian.crowd.crypto;

import com.atlassian.crowd.directory.LazyAttributesEvaluationDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Encryptor;
import com.atlassian.crowd.model.directory.DirectoryImpl;

import java.util.function.UnaryOperator;

public class DirectoryPasswordsEncryptor {
    private final Encryptor encryptor;

    public DirectoryPasswordsEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    public Directory decryptPasswords(Directory directory) {
        return transformPasswordAttributes(directory,
                encryptor::decrypt);
    }

    public Directory encryptPasswords(Directory directory) {
        return transformPasswordAttributes(directory,
                encryptor::encrypt);
    }

    private LazyAttributesEvaluationDirectory transformPasswordAttributes(Directory directory, UnaryOperator<String> transformer) {
        return new LazyAttributesEvaluationDirectory(directory, DirectoryImpl.PASSWORD_ATTRIBUTES, transformer);
    }

}
