/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.search.hibernate;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public class HQLQuery {
    protected final StringBuilder select = new StringBuilder("");
    protected final StringBuilder from = new StringBuilder(" FROM ");
    protected final StringBuilder where = new StringBuilder(" WHERE ");
    protected final StringBuilder orderBy = new StringBuilder(" ORDER BY ");
    protected int aliasCounter = 0;
    protected boolean distinctRequired = false;
    protected boolean whereRequired = false;
    protected boolean orderByRequired = false;
    protected final List<Object> parameterValues = new ArrayList<Object>();
    protected int maxResults;
    protected int startIndex;
    protected Function<List<Object[]>, List<?>> resultTransform;

    public StringBuilder appendSelect(CharSequence hql) {
        this.select.append(hql);
        return this.select;
    }

    public StringBuilder appendFrom(CharSequence hql) {
        this.from.append(hql);
        return this.from;
    }

    @Deprecated
    public StringBuilder appendWhere(CharSequence hql) {
        this.whereRequired = true;
        this.where.append(hql);
        return this.where;
    }

    public HQLQuery safeAppendWhere(CharSequence hql) {
        if (hql.toString().trim().length() > 0) {
            this.whereRequired = true;
            this.where.append(hql);
        }
        return this;
    }

    public StringBuilder appendOrderBy(CharSequence hql) {
        this.orderByRequired = true;
        this.orderBy.append(hql);
        return this.orderBy;
    }

    public int getNextAlias() {
        ++this.aliasCounter;
        return this.aliasCounter;
    }

    public String addParameterPlaceholder(@Nullable Object value) {
        this.parameterValues.add(value);
        return "?" + Integer.toString(this.parameterValues.size());
    }

    public List<Object> getParameterValues() {
        return Collections.unmodifiableList(this.parameterValues);
    }

    public void requireDistinct() {
        this.distinctRequired = true;
    }

    public void limitResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void offsetResults(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setResultTransform(Function<List<Object[]>, List<?>> resultTransform) {
        Preconditions.checkState((this.resultTransform == null ? 1 : 0) != 0, (Object)"Result transform already set");
        this.resultTransform = resultTransform;
    }

    public Function<List<Object[]>, List<?>> getResultTransform() {
        return this.resultTransform;
    }

    public String toString() {
        StringBuilder hql = new StringBuilder("SELECT ");
        if (this.distinctRequired) {
            hql.append("DISTINCT ");
        }
        hql.append((CharSequence)this.select);
        hql.append((CharSequence)this.from);
        if (this.whereRequired) {
            hql.append((CharSequence)this.where);
        }
        if (this.orderByRequired) {
            hql.append((CharSequence)this.orderBy);
        }
        return hql.toString();
    }
}

