/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.token;

import com.atlassian.crowd.dao.token.TokenDAO;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.cache.CacheManager;
import com.atlassian.crowd.manager.cache.CacheManagerException;
import com.atlassian.crowd.manager.cache.NotInCacheException;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.TokenTermKeys;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataRetrievalFailureException;

public class TokenDAOMemory
implements TokenDAO {
    public static final String RANDOM_HASH_CACHE = Token.class.getName() + ".random-hash-cache";
    public static final String IDENTIFIER_HASH_CAHE = Token.class.getName() + ".identifier-hash-cache";
    private static final Logger logger = LoggerFactory.getLogger(TokenDAOMemory.class);
    private CacheManager cacheManager;

    @Override
    public Token findByRandomHash(String randomHash) throws ObjectNotFoundException {
        Token token = null;
        try {
            token = (Token)this.cacheManager.get(RANDOM_HASH_CACHE, (Serializable)((Object)randomHash));
        }
        catch (CacheManagerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (NotInCacheException e) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)randomHash);
        }
        return token;
    }

    @Override
    public Token findByIdentifierHash(String identifierHash) throws ObjectNotFoundException {
        Token token = null;
        try {
            token = (Token)this.cacheManager.get(IDENTIFIER_HASH_CAHE, (Serializable)((Object)identifierHash));
        }
        catch (CacheManagerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (NotInCacheException e) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)identifierHash);
        }
        return token;
    }

    @Override
    public Token add(Token token) {
        try {
            this.cacheManager.put(RANDOM_HASH_CACHE, (Serializable)((Object)token.getRandomHash()), (Serializable)token);
            this.cacheManager.put(IDENTIFIER_HASH_CAHE, (Serializable)((Object)token.getIdentifierHash()), (Serializable)token);
        }
        catch (CacheManagerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return token;
    }

    @Override
    public Token update(Token token) {
        token.setLastAccessedDate(new Date());
        return this.add(token);
    }

    @Override
    public void remove(Token token) {
        try {
            this.cacheManager.remove(RANDOM_HASH_CACHE, (Serializable)((Object)token.getRandomHash()));
            this.cacheManager.remove(IDENTIFIER_HASH_CAHE, (Serializable)((Object)token.getIdentifierHash()));
        }
        catch (CacheManagerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<Token> search(EntityQuery query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.TOKEN) {
            throw new IllegalArgumentException("TokenDAO can only evaluate EntityQueries for Entity.TOKEN");
        }
        ArrayList<Token> tokens = new ArrayList();
        List<String> keys = this.findRandomHashKeys();
        for (String key : keys) {
            try {
                Token token = this.findByRandomHash(key);
                if (!this.tokenMatchesSearchRestriction(token, query.getSearchRestriction())) continue;
                tokens.add(token);
            }
            catch (ObjectNotFoundException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        tokens = SearchResultsUtil.constrainResults(tokens, (int)query.getStartIndex(), (int)query.getMaxResults());
        return tokens;
    }

    private boolean tokenMatchesSearchRestriction(Token token, SearchRestriction searchRestriction) {
        if (searchRestriction instanceof NullRestriction) {
            return true;
        }
        if (searchRestriction instanceof PropertyRestriction) {
            return this.tokenMatchesTermRestriction(token, (PropertyRestriction)searchRestriction);
        }
        if (searchRestriction instanceof BooleanRestriction) {
            return this.tokenMatchesMultiTermRestriction(token, (BooleanRestriction)searchRestriction);
        }
        throw new IllegalArgumentException("SearchRestriction unsupported: " + searchRestriction.getClass());
    }

    private boolean tokenMatchesMultiTermRestriction(Token token, BooleanRestriction multiRestriction) {
        if (multiRestriction.getBooleanLogic() == BooleanRestriction.BooleanLogic.AND) {
            boolean match = true;
            for (SearchRestriction restriction : multiRestriction.getRestrictions()) {
                if (this.tokenMatchesSearchRestriction(token, restriction)) continue;
                match = false;
                break;
            }
            return match;
        }
        if (multiRestriction.getBooleanLogic() == BooleanRestriction.BooleanLogic.OR) {
            boolean match = false;
            for (SearchRestriction restriction : multiRestriction.getRestrictions()) {
                if (!this.tokenMatchesSearchRestriction(token, restriction)) continue;
                match = true;
                break;
            }
            return match;
        }
        throw new IllegalArgumentException("BooleanLogic unsupported: " + multiRestriction.getBooleanLogic().getClass());
    }

    private boolean tokenMatchesTermRestriction(Token token, PropertyRestriction restriction) {
        if (restriction.getProperty().equals(TokenTermKeys.NAME)) {
            String value = (String)restriction.getValue();
            switch (restriction.getMatchMode()) {
                case STARTS_WITH: {
                    return token.getName().startsWith(value);
                }
                case CONTAINS: {
                    return token.getName().contains(value);
                }
            }
            return token.getName().equals(value);
        }
        if (restriction.getProperty().equals(TokenTermKeys.LAST_ACCESSED_DATE)) {
            Date value = (Date)restriction.getValue();
            switch (restriction.getMatchMode()) {
                case GREATER_THAN: {
                    return token.getLastAccessedDate().after(value);
                }
                case LESS_THAN: {
                    return token.getLastAccessedDate().before(value);
                }
            }
            return token.getLastAccessedDate().equals(value);
        }
        if (restriction.getProperty().equals(TokenTermKeys.DIRECTORY_ID)) {
            Long value = (Long)restriction.getValue();
            switch (restriction.getMatchMode()) {
                case GREATER_THAN: {
                    return token.getDirectoryId() > value;
                }
                case LESS_THAN: {
                    return token.getDirectoryId() < value;
                }
            }
            return token.getDirectoryId() == value.longValue();
        }
        if (restriction.getProperty().equals(TokenTermKeys.RANDOM_NUMBER)) {
            Long value = (Long)restriction.getValue();
            switch (restriction.getMatchMode()) {
                case GREATER_THAN: {
                    return token.getRandomNumber() > value;
                }
                case LESS_THAN: {
                    return token.getRandomNumber() < value;
                }
            }
            return token.getRandomNumber() == value.longValue();
        }
        throw new IllegalArgumentException("ProperyRestriction unsupported: " + restriction.getClass());
    }

    private List<String> findRandomHashKeys() {
        return this.cacheManager.getAllKeys(RANDOM_HASH_CACHE);
    }

    @Override
    public Token findByID(long ID) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("Currently we cannot load Token's by ID");
    }

    @Override
    public void remove(long directoryId, String name) {
        List<String> keys = this.findRandomHashKeys();
        for (String key : keys) {
            try {
                Token token = this.findByRandomHash(key);
                if (token.getDirectoryId() != directoryId || !token.getName().equals(name)) continue;
                this.remove(token);
            }
            catch (ObjectNotFoundException e) {}
        }
    }

    @Override
    public void removeAll(long directoryId) {
        List<String> keys = this.findRandomHashKeys();
        for (String key : keys) {
            try {
                Token token = this.findByRandomHash(key);
                if (token.getDirectoryId() != directoryId) continue;
                this.remove(token);
            }
            catch (ObjectNotFoundException e) {}
        }
    }

    @Override
    public void removeAccessedBefore(Date expiryTime) {
        List<String> keys = this.findRandomHashKeys();
        for (String key : keys) {
            try {
                Token token = this.findByRandomHash(key);
                if (!token.getLastAccessedDate().before(expiryTime)) continue;
                this.remove(token);
            }
            catch (ObjectNotFoundException e) {}
        }
    }

    public Class getPersistentClass() {
        return Token.class.getClass();
    }

    public void save(Object persistentObject) {
        this.add((Token)persistentObject);
    }

    public void update(Object persistentObject) {
        this.update((Token)persistentObject);
    }

    public void remove(Object persistentObject) {
        this.remove((Token)persistentObject);
    }

    public Object load(long ID) {
        throw new UnsupportedOperationException("Currently we cannot load Tokens by ID");
    }

    @Override
    public Collection<Token> loadAll() {
        List<String> keys = this.findRandomHashKeys();
        ArrayList<Token> tokens = new ArrayList<Token>(keys.size());
        for (String key : keys) {
            try {
                Token token = this.findByRandomHash(key);
                tokens.add(token);
            }
            catch (ObjectNotFoundException e) {}
        }
        return tokens;
    }

    @Override
    public void saveAll(Collection<Token> tokens) {
        if (tokens == null) {
            throw new DataRetrievalFailureException("Unable to save an empty collection of tokens");
        }
        Iterator<Token> tokenIt = tokens.iterator();
        while (tokenIt.hasNext()) {
            this.save(tokenIt.next());
        }
    }

    @Override
    public void removeAll() {
        this.cacheManager.removeAll(RANDOM_HASH_CACHE);
        this.cacheManager.removeAll(IDENTIFIER_HASH_CAHE);
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

