/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.loader;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.migration.XMLRestoreFinishedEvent;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.util.concurrent.ConcurrentMap;

public abstract class CachingDirectoryInstanceLoader
implements DirectoryInstanceLoader {
    private final EventPublisher eventPublisher;
    private final ConcurrentMap<Long, RemoteDirectory> directoryCache = CopyOnWriteMap.builder().newHashMap();

    public CachingDirectoryInstanceLoader(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.eventPublisher.register((Object)this);
    }

    public RemoteDirectory getDirectory(Directory directory) throws DirectoryInstantiationException {
        Long directoryId = directory.getId();
        RemoteDirectory remoteDirectory = (RemoteDirectory)this.directoryCache.get(directoryId);
        if (remoteDirectory != null) {
            return remoteDirectory;
        }
        remoteDirectory = this.getNewDirectory(directory);
        RemoteDirectory existingDirectory = this.directoryCache.putIfAbsent(directoryId, remoteDirectory);
        return existingDirectory != null ? existingDirectory : remoteDirectory;
    }

    protected EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    protected abstract RemoteDirectory getNewDirectory(Directory var1) throws DirectoryInstantiationException;

    @EventListener
    public void handleEvent(DirectoryUpdatedEvent event) {
        Directory directory = event.getDirectory();
        this.directoryCache.remove(directory.getId());
    }

    @EventListener
    public void handleEvent(DirectoryDeletedEvent event) {
        Directory directory = event.getDirectory();
        this.directoryCache.remove(directory.getId());
    }

    @EventListener
    public void handleEvent(XMLRestoreFinishedEvent event) {
        this.directoryCache.clear();
    }
}

