/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.property;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.property.PropertyDAO;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.model.property.PropertyId;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDAOHibernate
extends HibernateDao
implements PropertyDAO {
    @Override
    public Class getPersistentClass() {
        return Property.class;
    }

    @Override
    public Property find(final String key, final String name) throws ObjectNotFoundException {
        Object result = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.get(PropertyDAOHibernate.this.getPersistentClass(), (Serializable)new PropertyId(key, name));
            }
        });
        if (result == null) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)name);
        }
        return (Property)result;
    }

    @Override
    public List<Property> findAll(final String key) {
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return CriteriaFactory.createCriteria(session, PropertyDAOHibernate.this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"propertyId.key", (Object)key)).list();
            }
        });
    }

    @Override
    public Property add(Property property) {
        super.save(property);
        return property;
    }

    @Override
    public Property update(Property property) {
        super.update(property);
        return property;
    }

    @Override
    public void remove(String key, String name) {
        try {
            Property property = this.find(key, name);
            super.remove(property);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public List<Property> findAll() {
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return CriteriaFactory.createCriteria(session, PropertyDAOHibernate.this.getPersistentClass()).list();
            }
        });
    }
}

