/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.group;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.dao.group.InternalGroupDao;
import com.atlassian.crowd.dao.membership.InternalMembershipDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.model.InternalAttributesHelper;
import com.atlassian.crowd.model.InternalDirectoryEntity;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.group.InternalGroupAttribute;
import com.atlassian.crowd.model.group.InternalGroupWithAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResultWithIdReferences;
import com.atlassian.crowd.util.persistence.hibernate.batch.TransactionGroup;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate3.operation.MergeOperation;
import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupDAOHibernate
extends HibernateDao
implements InternalGroupDao,
GroupDao {
    private DirectoryDAOHibernate directoryDao;
    private InternalMembershipDao internalMembershipDao;
    private HQLQueryTranslater hqlQueryTranslater;
    private InternalAttributesHelper internalAttributesHelper;

    @Override
    public Class getPersistentClass() {
        return InternalGroup.class;
    }

    @Override
    public InternalGroup findByName(final long directoryId, final String groupName) throws GroupNotFoundException {
        Object result = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return CriteriaFactory.createCriteria(session, InternalGroup.class).add((Criterion)Expression.eq((String)"directory.id", (Object)directoryId)).add((Criterion)Expression.eq((String)"lowerName", (Object)IdentifierUtils.toLowerCase((String)groupName))).uniqueResult();
            }
        });
        if (result == null) {
            throw new GroupNotFoundException(groupName);
        }
        return (InternalGroup)((Object)result);
    }

    public InternalGroupWithAttributes findByNameWithAttributes(long directoryId, String groupName) throws GroupNotFoundException {
        InternalGroup group = this.findByName(directoryId, groupName);
        Set<InternalGroupAttribute> attributesList = this.findGroupAttributes(group.getId());
        Map<String, Set<String>> attributesMap = this.internalAttributesHelper.attributesListToMap(attributesList);
        return new InternalGroupWithAttributes(group, attributesMap);
    }

    @Override
    public Set<InternalGroupAttribute> findGroupAttributes(final long groupId) {
        return Sets.newHashSet((Iterable)this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return CriteriaFactory.createCriteria(session, InternalGroupAttribute.class).add((Criterion)Expression.eq((String)"group.id", (Object)groupId)).list();
            }
        }));
    }

    public InternalGroup add(Group group) throws DirectoryNotFoundException {
        return this.add(group, false);
    }

    public InternalGroup addLocal(Group group) throws DirectoryNotFoundException {
        return this.add(group, true);
    }

    private InternalGroup add(Group group, boolean local) throws DirectoryNotFoundException {
        InternalGroup groupToAdd = new InternalGroup(group, (Directory)this.getDirectory(group));
        groupToAdd.setLocal(local);
        groupToAdd.setCreatedDateToNow();
        groupToAdd.setUpdatedDateToNow();
        super.save((Object)groupToAdd);
        return groupToAdd;
    }

    private DirectoryImpl getDirectory(Group group) throws DirectoryNotFoundException {
        Validate.notNull((Object)group.getDirectoryId(), (String)"Cannot add a group with null directoryId");
        return this.directoryDao.findById(group.getDirectoryId());
    }

    public InternalGroup update(Group group) throws GroupNotFoundException {
        InternalGroup groupToUpdate = this.findByName(group.getDirectoryId(), group.getName());
        if (groupToUpdate.getType() != group.getType()) {
            throw new UnsupportedOperationException("Cannot modify the GroupType for an Internal group");
        }
        groupToUpdate.updateDetailsFrom(group);
        groupToUpdate.setUpdatedDateToNow();
        super.update((Object)groupToUpdate);
        return groupToUpdate;
    }

    public InternalGroup rename(Group group, String newName) throws GroupNotFoundException {
        InternalGroup groupToRename = this.findByName(group.getDirectoryId(), group.getName());
        String oldName = groupToRename.getName();
        groupToRename.renameTo(newName);
        groupToRename.setUpdatedDateToNow();
        super.update((Object)groupToRename);
        this.internalMembershipDao.renameGroupRelationships(groupToRename.getDirectoryId(), oldName, groupToRename.getName());
        return groupToRename;
    }

    public void storeAttributes(Group group, Map<String, Set<String>> attributes) throws GroupNotFoundException {
        InternalGroupWithAttributes groupToUpdate = this.findByNameWithAttributes(group.getDirectoryId(), group.getName());
        for (String string : attributes.keySet()) {
            if (groupToUpdate.getValue(string) == null) continue;
            this.removeAttributes(groupToUpdate.getInternalGroup(), string);
        }
        for (Map.Entry entry : attributes.entrySet()) {
            for (String value : (Set)entry.getValue()) {
                this.addAttribute(groupToUpdate.getInternalGroup(), (String)entry.getKey(), value);
            }
        }
    }

    private void addAttribute(InternalGroup group, String attributeName, String attributeValue) {
        InternalGroupAttribute attribute = new InternalGroupAttribute(group, attributeName, attributeValue);
        this.getHibernateTemplate().save((Object)attribute);
    }

    public void removeAttribute(Group group, String attributeName) throws GroupNotFoundException {
        this.removeAttributes(this.findByName(group.getDirectoryId(), group.getName()), attributeName);
    }

    private void removeAttributes(final InternalGroup group, final String attributeName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeInternalGroupAttributes").setEntity("group", (Object)group).setString("attributeName", attributeName).executeUpdate();
            }
        });
    }

    public void remove(Group group) throws GroupNotFoundException {
        final InternalGroup groupToRemove = this.findByName(group.getDirectoryId(), group.getName());
        this.internalMembershipDao.removeGroupMembers(group.getDirectoryId(), group.getName());
        this.internalMembershipDao.removeGroupMemberships(group.getDirectoryId(), group.getName());
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeAllInternalGroupAttributes").setEntity("group", (Object)groupToRemove).executeUpdate();
            }
        });
        super.remove((Object)groupToRemove);
    }

    public void removeAllGroups(long directoryId, Set<String> groupNames) {
        Collection<InternalGroup> groups = this.findByNames(directoryId, groupNames);
        for (InternalGroup group : groups) {
            try {
                this.remove((Group)group);
            }
            catch (GroupNotFoundException e) {}
        }
    }

    @Override
    public void removeAll(final long directoryId) {
        this.internalMembershipDao.removeAllRelationships(directoryId);
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.getNamedQuery("removeAllInternalGroupAttributesInDirectory").setLong("directoryId", directoryId).executeUpdate();
                return session.getNamedQuery("removeAllGroupsInDirectory").setLong("directoryId", directoryId).executeUpdate();
            }
        });
    }

    public <T> List<T> search(final long directoryId, final EntityQuery<T> query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.GROUP) {
            throw new IllegalArgumentException("GroupDAO can only evaluate EntityQueries for Entity.GROUP");
        }
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                HQLQuery hqlQuery = GroupDAOHibernate.this.hqlQueryTranslater.asHQL(directoryId, query);
                Query hibernateQuery = session.createQuery(hqlQuery.toString()).setFirstResult(query.getStartIndex());
                if (query.getMaxResults() != -1) {
                    hibernateQuery.setMaxResults(query.getMaxResults());
                }
                ListIterator<Object> iterator = hqlQuery.getParameterValues().listIterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    hibernateQuery.setParameter(iterator.previousIndex(), value);
                }
                return HibernateSearchResultsTransformer.transformResults(hibernateQuery.list());
            }
        });
    }

    public BatchResult<Group> addAll(Set<? extends Group> groups) throws DirectoryNotFoundException {
        HashSet<InternalGroup> groupsToAdd = new HashSet<InternalGroup>();
        HashSet<Group> groupsFailedValidation = new HashSet<Group>();
        for (Group group : groups) {
            try {
                InternalGroup groupToAdd = new InternalGroup(group, (Directory)this.getDirectory(group));
                groupToAdd.setCreatedDateToNow();
                groupToAdd.setUpdatedDateToNow();
                groupsToAdd.add(groupToAdd);
            }
            catch (IllegalArgumentException e) {
                this.logger.error((Object)("Could not add group <" + group.getName() + ">: " + e.getMessage()));
                groupsFailedValidation.add(group);
            }
        }
        BatchResult daoResult = this.batchProcessor.execute(new MergeOperation(), groupsToAdd);
        BatchResult batchResult = new BatchResult(groups.size());
        batchResult.addSuccesses((Collection)daoResult.getSuccessfulEntities());
        batchResult.addFailures((Collection)daoResult.getFailedEntities());
        batchResult.addFailures(groupsFailedValidation);
        return batchResult;
    }

    @Override
    public BatchResultWithIdReferences<Group> addAll(Collection<InternalGroupWithAttributes> groups) {
        HashSet groupsToAdd = new HashSet();
        HashSet<InternalGroupWithAttributes> groupsFailedValidation = new HashSet<InternalGroupWithAttributes>();
        for (InternalGroupWithAttributes group : groups) {
            try {
                InternalGroup groupToAdd = group.getInternalGroup();
                HashSet<InternalGroupAttribute> hashSet = new HashSet<InternalGroupAttribute>();
                for (String name : group.getKeys()) {
                    for (String val : group.getValues(name)) {
                        InternalGroupAttribute attrib = new InternalGroupAttribute(groupToAdd, name, val);
                        hashSet.add(attrib);
                    }
                }
                groupsToAdd.add(new TransactionGroup(groupToAdd, hashSet));
            }
            catch (IllegalArgumentException e) {
                this.logger.error((Object)("Could not add group <" + group.getName() + ">: " + e.getMessage()));
                groupsFailedValidation.add(group);
            }
        }
        BatchResult daoResult = this.batchProcessor.execute(new MergeOperation(), groupsToAdd);
        BatchResultWithIdReferences<Group> result = new BatchResultWithIdReferences<Group>(groups.size());
        for (TransactionGroup transactionGroup : daoResult.getFailedEntities()) {
            result.addFailure(transactionGroup.getPrimaryObject());
        }
        result.addFailures(groupsFailedValidation);
        for (TransactionGroup transactionGroup : groupsToAdd) {
            result.addIdReference((InternalDirectoryEntity)((Object)transactionGroup.getPrimaryObject()));
        }
        return result;
    }

    @Override
    public Collection<InternalGroup> findByNames(long directoryID, Collection<String> groupnames) {
        return this.batchFinder.find(directoryID, groupnames, InternalGroup.class);
    }

    public void setDirectoryDao(DirectoryDAOHibernate directoryDao) {
        this.directoryDao = directoryDao;
    }

    public void setMembershipDAO(InternalMembershipDao internalMembershipDao) {
        this.internalMembershipDao = internalMembershipDao;
    }

    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    public void setInternalAttributesHelper(InternalAttributesHelper internalAttributesHelper) {
        this.internalAttributesHelper = internalAttributesHelper;
    }
}

