/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import com.atlassian.crowd.util.persistence.hibernate.ResettableTableHiLoGenerator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

public class ResetableHiLoGeneratorHelper {
    private static final Logger logger = Logger.getLogger(ResetableHiLoGeneratorHelper.class);
    public static final String HIBERNATE_UNIQUE_KEY_TABLE = "hibernate_unique_key";
    public static final String HIBERNATE_UNIQUE_KEY_COLUMN = "next_hi";
    private SessionFactory sessionFactory;

    public long getHiValue() throws SQLException {
        Statement statement = null;
        Connection connection = null;
        long result = 0L;
        try {
            Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
            connection = session.connection();
            statement = connection.createStatement();
            ResultSet rs = statement.executeQuery("select next_hi from hibernate_unique_key");
            if (rs.next()) {
                result = rs.getLong(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Error finding maximum next_hi value", (Throwable)e);
            throw e;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (SQLException e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextHiValue(List errors) {
        Statement statement = null;
        Connection connection = null;
        try {
            Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
            connection = session.connection();
            statement = connection.createStatement();
            Map metaDataMap = this.sessionFactory.getAllClassMetadata();
            long maximumId = 0L;
            int maxLo = 0;
            for (Map.Entry entry : metaDataMap.entrySet()) {
                long value;
                String sql;
                ResultSet rs;
                String className = (String)entry.getKey();
                EntityPersister persister = ((SessionFactoryImplementor)this.sessionFactory).getEntityPersister(className);
                if (!(persister instanceof SingleTableEntityPersister) || !(persister.getIdentifierGenerator() instanceof ResettableTableHiLoGenerator)) continue;
                SingleTableEntityPersister entityPersister = (SingleTableEntityPersister)persister;
                ResettableTableHiLoGenerator generator = (ResettableTableHiLoGenerator)persister.getIdentifierGenerator();
                if (maxLo == 0) {
                    maxLo = generator.getMaxLo();
                } else if (maxLo != generator.getMaxLo()) {
                    errors.add("One generator uses " + maxLo + " for maxLo, generator for " + className + " uses " + generator.getMaxLo());
                }
                String[] idColumnNames = entityPersister.getIdentifierColumnNames();
                if (idColumnNames.length != 1) {
                    errors.add("expected a single id column for " + className + " found " + idColumnNames.length);
                }
                if (!(rs = statement.executeQuery(sql = "select max(" + idColumnNames[0] + ") from " + entityPersister.getTableName())).next()) {
                    errors.add("no maximum id returned for " + className);
                }
                if ((value = rs.getLong(1)) > maximumId) {
                    maximumId = value;
                }
                rs.close();
            }
            int nextHi = (int)(maximumId / (long)(maxLo + 1)) + 1;
            logger.info((Object)("Setting new next_hi to " + nextHi));
            if (statement.executeUpdate("update hibernate_unique_key set next_hi = " + nextHi) == 0 && statement.executeUpdate("insert into hibernate_unique_key values(" + nextHi + ")") == 0) {
                errors.add("failed to insert initial next_hi value");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error finding maximum next_hi value", (Throwable)e);
            errors.add(e.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (SQLException e) {}
            }
            if (!errors.isEmpty()) {
                // empty if block
            }
            logger.info((Object)"Completed database update: HiLoIdRepairUpgradeTask");
        }
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

