/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.AbstractInternalDirectory;
import com.atlassian.crowd.directory.InternalDirectoryUtils;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.spi.BatchResult;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingDirectory
extends AbstractInternalDirectory {
    public CachingDirectory(InternalDirectoryUtils internalDirectoryUtils, PasswordEncoderFactory passwordEncoderFactory, DirectoryDao directoryDao, UserDao userDao, GroupDao groupDao, MembershipDao membershipDao) {
        super(internalDirectoryUtils, passwordEncoderFactory, directoryDao, userDao, groupDao, membershipDao);
    }

    @Override
    public com.atlassian.crowd.model.user.User addUser(UserTemplate user, PasswordCredential credential) throws InvalidCredentialException, InvalidUserException, UserAlreadyExistsException, OperationFailedException {
        com.atlassian.crowd.model.user.User addedUser;
        this.internalDirectoryUtils.validateDirectoryForEntity((DirectoryEntity)user, this.directoryId);
        try {
            addedUser = this.userDao.add((com.atlassian.crowd.model.user.User)user, credential);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidUserException((User)user, e.getMessage(), (Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
        return addedUser;
    }

    @Override
    public Group addLocalGroup(GroupTemplate group) throws InvalidGroupException, OperationFailedException {
        this.internalDirectoryUtils.validateDirectoryForEntity((DirectoryEntity)group, this.directoryId);
        this.internalDirectoryUtils.validateGroupName((Group)group, group.getName());
        try {
            return this.groupDao.addLocal((Group)group);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidGroupException((Group)group, e.getMessage(), (Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    public Collection<com.atlassian.crowd.model.user.User> addAllUsers(Set<UserTemplateWithCredentialAndAttributes> users) {
        for (UserTemplateWithCredentialAndAttributes user : users) {
            this.internalDirectoryUtils.validateDirectoryForEntity((DirectoryEntity)user, this.directoryId);
        }
        BatchResult daoResult = this.userDao.addAll(users);
        return daoResult.getFailedEntities();
    }

    public Collection<Group> addAllGroups(Set<GroupTemplate> groups) {
        BatchResult daoResult;
        for (GroupTemplate group : groups) {
            this.internalDirectoryUtils.validateDirectoryForEntity((DirectoryEntity)group, this.directoryId);
            this.internalDirectoryUtils.validateGroupName((Group)group, group.getName());
        }
        try {
            daoResult = this.groupDao.addAll(groups);
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
        return daoResult.getFailedEntities();
    }

    public Collection<String> addAllUsersToGroup(Set<String> userNames, String groupName) throws GroupNotFoundException {
        Validate.notNull(userNames, (String)"userNames cannot be null");
        Validate.notEmpty((String)groupName, (String)"groupName cannot be null or empty");
        return this.membershipDao.addAllUsersToGroup(this.getDirectoryId(), userNames, groupName);
    }

    @Override
    public com.atlassian.crowd.model.user.User updateUser(UserTemplate user) throws InvalidUserException, UserNotFoundException {
        this.internalDirectoryUtils.validateDirectoryForEntity((DirectoryEntity)user, this.directoryId);
        try {
            return this.userDao.update((com.atlassian.crowd.model.user.User)user);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidUserException((User)user, e.getMessage(), (Throwable)e);
        }
    }
}

