/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.alias;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.alias.AliasDAO;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.alias.Alias;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import java.sql.SQLException;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasDAOHibernate
extends HibernateDao
implements AliasDAO {
    private HQLQueryTranslater hqlQueryTranslater;

    @Override
    public Class getPersistentClass() {
        return Alias.class;
    }

    private Alias findAliasObjectByUsername(final Application application, final String username) {
        return (Alias)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return CriteriaFactory.createCriteria(session, AliasDAOHibernate.this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"application", (Object)application)).add((Criterion)Restrictions.eq((String)"lowerName", (Object)IdentifierUtils.toLowerCase((String)username))).uniqueResult();
            }
        });
    }

    private Alias findAliasObjectByAlias(final Application application, final String alias) {
        return (Alias)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return CriteriaFactory.createCriteria(session, AliasDAOHibernate.this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"application", (Object)application)).add((Criterion)Restrictions.eq((String)"lowerAlias", (Object)IdentifierUtils.toLowerCase((String)alias))).uniqueResult();
            }
        });
    }

    @Override
    public List<String> search(final EntityQuery<String> entityQuery) {
        if (entityQuery.getEntityDescriptor().getEntityType() != Entity.ALIAS) {
            throw new IllegalArgumentException("AliasDAO can only evaluate EntityQueries for Entity.ALIAS");
        }
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                HQLQuery hqlQuery = AliasDAOHibernate.this.hqlQueryTranslater.asHQL(entityQuery);
                Query hibernateQuery = session.createQuery(hqlQuery.toString()).setFirstResult(entityQuery.getStartIndex());
                if (entityQuery.getMaxResults() != -1) {
                    hibernateQuery.setMaxResults(entityQuery.getMaxResults());
                }
                ListIterator<Object> iterator = hqlQuery.getParameterValues().listIterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    hibernateQuery.setParameter(iterator.previousIndex(), value);
                }
                return HibernateSearchResultsTransformer.transformResults(hibernateQuery.list());
            }
        });
    }

    @Override
    public String findAliasByUsername(Application application, String username) {
        Alias aliasObject = this.findAliasObjectByUsername(application, username);
        return aliasObject == null ? null : aliasObject.getAlias();
    }

    @Override
    public String findUsernameByAlias(Application application, String alias) {
        Alias aliasObject = this.findAliasObjectByAlias(application, alias);
        return aliasObject == null ? null : aliasObject.getName();
    }

    @Override
    public void storeAlias(Application application, String username, String alias) {
        Validate.notNull((Object)application, (String)"Application cannot be null");
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("Username cannot be blank");
        }
        if (StringUtils.isBlank((String)alias)) {
            throw new IllegalArgumentException("Alias cannot be blank");
        }
        Alias aliasObject = this.findAliasObjectByUsername(application, username);
        if (aliasObject != null) {
            aliasObject.setAlias(alias);
        } else {
            aliasObject = new Alias(application, username, alias);
        }
        this.saveOrUpdate(aliasObject);
    }

    @Override
    public void removeAlias(Application application, String username) {
        Alias aliasObject = this.findAliasObjectByUsername(application, username);
        if (aliasObject != null) {
            this.remove(aliasObject);
        }
    }

    @Override
    public void removeAliases(final Application application) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.getNamedQuery("removeAllAliasesForApplication");
                query.setEntity("application", (Object)application);
                return query.executeUpdate();
            }
        });
    }

    public List<Alias> findAll() {
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return CriteriaFactory.createCriteria(session, AliasDAOHibernate.this.getPersistentClass()).list();
            }
        });
    }

    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }
}

