package com.atlassian.crowd.model.permission;


import java.io.Serializable;
import java.util.Date;

import com.atlassian.crowd.manager.permission.PermittedGroup;
import com.atlassian.crowd.model.application.GroupMapping;

public class InternalGrantedPermission implements Serializable, PermittedGroup {
    private Long id;
    private UserPermission permission;
    private Date createdDate;
    private GroupMapping groupMapping;

    private InternalGrantedPermission() {
    }

    public InternalGrantedPermission(UserPermission permission, GroupMapping groupMapping) {
        this.permission = permission;
        this.groupMapping = groupMapping;
    }

    public InternalGrantedPermission(Long id, Date createdDate, UserPermission permission, GroupMapping groupMapping) {
        this(permission, groupMapping);
        this.id = id;
        this.createdDate = createdDate;
    }

    public Long getId() {
        return id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public Date getCreatedDate() {
        return createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public UserPermission getPermission() {
        return permission;
    }

    public void setPermission(UserPermission permission) {
        this.permission = permission;
    }

    public GroupMapping getGroupMapping() {
        return groupMapping;
    }

    private void setGroupMapping(GroupMapping groupMapping) {
        this.groupMapping = groupMapping;
    }

    @Override
    public Long getDirectoryId() {
        return getGroupMapping().getDirectory().getId();
    }

    @Override
    public String getDirectoryName() {
        return getGroupMapping().getDirectory().getName();
    }

    @Override
    public String getGroupName() {
        return getGroupMapping().getGroupName();
    }

    @Override
    public String toString() {
        return "InternalGrantedPermission{" +
                "id=" + id +
                ", permission=" + permission +
                ", createdDate=" + createdDate +
                ", groupMapping=" + groupMapping +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        InternalGrantedPermission that = (InternalGrantedPermission) o;

        if (createdDate != null ? !createdDate.equals(that.createdDate) : that.createdDate != null) return false;
        if (!groupMapping.equals(that.groupMapping)) return false;
        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (permission != that.permission) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + permission.hashCode();
        result = 31 * result + (createdDate != null ? createdDate.hashCode() : 0);
        result = 31 * result + groupMapping.hashCode();
        return result;
    }
}
