package com.atlassian.crowd.model;

import java.util.HashSet;
import java.util.Set;

import com.atlassian.crowd.embedded.api.Directory;

public abstract class InternalDirectoryEntity<T extends InternalEntityAttribute> extends InternalEntity implements DirectoryEntity {
    protected Directory directory;
    protected Set<T> attributes = new HashSet<>();

    protected InternalDirectoryEntity() {

    }

    protected InternalDirectoryEntity(final InternalEntityTemplate template, final Directory directory) {
        super(template);
        this.directory = directory;
    }

    public long getDirectoryId() {
        return getDirectory() != null ? getDirectory().getId() : -1L;
    }

    public Directory getDirectory() {
        return directory;
    }

    private void setDirectory(final Directory directory) {
        this.directory = directory;
    }

    public Set<T> getAttributes() {
        return attributes;
    }

    // mapped in Hibernate but not used in our code
    @SuppressWarnings("UnusedDeclaration")
    private void setAttributes(final Set<T> attributes) {
        this.attributes = attributes;
    }
}
