package com.atlassian.crowd.directory.loader;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryInstantiationException;

/**
 * An abstract implementation of {@link DirectoryInstanceLoader} which provides a default implementation
 * of {@link #getDirectory(Directory)}
 *
 * @since v2.8
 */
public abstract class AbstractDirectoryInstanceLoader implements DirectoryInstanceLoader {

    public RemoteDirectory getDirectory(final Directory directory) throws DirectoryInstantiationException {
        return getRawDirectory(directory.getId(), directory.getImplementationClass(), directory.getAttributes());
    }

}
