package com.atlassian.crowd.manager.permission;


import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * Non-persisted implementation to return to the service layer
 */
public class DirectoryGroupImpl implements DirectoryGroup {
    private final Long directoryId;
    private final String directoryName;
    private final String groupName;

    public DirectoryGroupImpl(Long directoryId, String directoryName, String groupName) {
        this.directoryId = directoryId;
        this.directoryName = directoryName;
        this.groupName = groupName;
    }

    public Long getDirectoryId() {
        return directoryId;
    }

    public String getDirectoryName() {
        return directoryName;
    }

    public String getGroupName() {
        return groupName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("directoryId", directoryId)
                .append("directoryName", directoryName)
                .append("groupName", groupName).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DirectoryGroupImpl that = (DirectoryGroupImpl) o;

        if (directoryId != null ? !directoryId.equals(that.directoryId) : that.directoryId != null) return false;
        if (directoryName != null ? !directoryName.equals(that.directoryName) : that.directoryName != null)
            return false;
        if (groupName != null ? !groupName.equals(that.groupName) : that.groupName != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = directoryId != null ? directoryId.hashCode() : 0;
        result = 31 * result + (directoryName != null ? directoryName.hashCode() : 0);
        result = 31 * result + (groupName != null ? groupName.hashCode() : 0);
        return result;
    }
}
