/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchFinder;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.io.Serializable;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class HibernateDao
extends HibernateDaoSupport {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected BatchProcessor batchProcessor;
    protected BatchFinder batchFinder;

    public void save(Object persistentObject) throws DataAccessException {
        this.logger.debug("Saving object: " + persistentObject);
        this.getHibernateTemplate().save(persistentObject);
    }

    public void saveOrUpdate(Object persistentObject) throws DataAccessException {
        this.logger.debug("Saving or updating object: " + persistentObject);
        this.getHibernateTemplate().saveOrUpdate(persistentObject);
    }

    public void update(Object persistentObject) throws DataAccessException {
        this.logger.debug("Updating object: " + persistentObject);
        this.getHibernateTemplate().saveOrUpdate(persistentObject);
    }

    public void remove(Object persistentObject) throws DataAccessException {
        this.logger.debug("Deleting object: " + persistentObject);
        this.getHibernateTemplate().delete(persistentObject);
    }

    public Object load(final long ID) throws ObjectNotFoundException {
        Object obj = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                return session.get(HibernateDao.this.getPersistentClass(), (Serializable)Long.valueOf(ID));
            }
        });
        if (obj == null) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)ID);
        }
        this.logger.debug("Loaded object: " + obj);
        return obj;
    }

    public Object loadReference(final long id) {
        return this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                return session.load(HibernateDao.this.getPersistentClass(), (Serializable)Long.valueOf(id));
            }
        });
    }

    public abstract Class getPersistentClass();

    public void setBatchProcessor(BatchProcessor batchProcessor) {
        this.batchProcessor = batchProcessor;
    }

    public void setBatchFinder(BatchFinder batchFinder) {
        this.batchFinder = batchFinder;
    }
}

