/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.user;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.dao.membership.InternalMembershipDao;
import com.atlassian.crowd.dao.user.InternalUserDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.InternalAttributesHelper;
import com.atlassian.crowd.model.InternalDirectoryEntity;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.InternalUserAttribute;
import com.atlassian.crowd.model.user.InternalUserWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResultWithIdReferences;
import com.atlassian.crowd.util.persistence.hibernate.batch.HibernateOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.TransactionGroup;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate3.operation.MergeOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate3.operation.RemoveUserOperation;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.springframework.orm.hibernate3.HibernateCallback;

public class UserDAOHibernate
extends HibernateDao
implements InternalUserDao,
UserDao {
    private DirectoryDAOHibernate directoryDAO;
    private InternalMembershipDao internalMembershipDao;
    private HQLQueryTranslater hqlQueryTranslater;
    private InternalAttributesHelper internalAttributesHelper;

    @Override
    public Class getPersistentClass() {
        return InternalUser.class;
    }

    public InternalUser findByName(long directoryId, String username) throws UserNotFoundException {
        InternalUser user = this.findByNameInternal(directoryId, username);
        if (user == null) {
            throw new UserNotFoundException(username);
        }
        return user;
    }

    private InternalUser findByNameInternal(final long directoryId, final String username) {
        return (InternalUser)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return CriteriaFactory.createCriteria(session, InternalUser.class).add((Criterion)Expression.eq((String)"directory.id", (Object)directoryId)).add((Criterion)Expression.eq((String)"lowerName", (Object)IdentifierUtils.toLowerCase((String)username))).uniqueResult();
            }
        });
    }

    public PasswordCredential getCredential(long directoryId, String username) throws UserNotFoundException {
        return this.findByName(directoryId, username).getCredential();
    }

    public List<PasswordCredential> getCredentialHistory(long directoryId, String username) throws UserNotFoundException {
        return this.findByName(directoryId, username).getCredentialHistory();
    }

    public InternalUserWithAttributes findByNameWithAttributes(long directoryId, String username) throws UserNotFoundException {
        InternalUser user = this.findByName(directoryId, username);
        Set<InternalUserAttribute> attributesList = this.findUserAttributes(user.getId());
        Map attributesMap = this.internalAttributesHelper.attributesListToMap(attributesList);
        return new InternalUserWithAttributes(user, attributesMap);
    }

    public Set<InternalUserAttribute> findUserAttributes(final long userID) {
        return Sets.newHashSet((Iterable)this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return CriteriaFactory.createCriteria(session, InternalUserAttribute.class).add((Criterion)Expression.eq((String)"user.id", (Object)userID)).list();
            }
        }));
    }

    public InternalUser add(User user, PasswordCredential credential) throws DirectoryNotFoundException, UserAlreadyExistsException {
        InternalUser existingUser = this.findByNameInternal(user.getDirectoryId(), user.getName());
        if (existingUser != null) {
            throw new UserAlreadyExistsException(existingUser.getDirectoryId(), existingUser.getName());
        }
        InternalUser userToAdd = new InternalUser(user, (Directory)this.getDirectory(user), credential);
        userToAdd.setCreatedDateToNow();
        userToAdd.setUpdatedDateToNow();
        super.save(userToAdd);
        return userToAdd;
    }

    private DirectoryImpl getDirectory(User user) throws DirectoryNotFoundException {
        Validate.notNull((Object)user.getDirectoryId(), (String)"Cannot add user with null directoryId");
        try {
            return (DirectoryImpl)this.directoryDAO.load(user.getDirectoryId());
        }
        catch (ObjectNotFoundException e) {
            throw new DirectoryNotFoundException(Long.valueOf(user.getDirectoryId()), (Throwable)e);
        }
    }

    public InternalUser update(User user) throws UserNotFoundException {
        InternalUser userToUpdate = this.findByName(user.getDirectoryId(), user.getName());
        userToUpdate.updateDetailsFrom(user);
        userToUpdate.setUpdatedDateToNow();
        super.update(userToUpdate);
        return userToUpdate;
    }

    public void updateCredential(User user, PasswordCredential credential, int maxPasswordHistory) throws UserNotFoundException {
        InternalUser userToUpdate = this.findByName(user.getDirectoryId(), user.getName());
        userToUpdate.updateCredentialTo(credential, maxPasswordHistory);
        userToUpdate.setUpdatedDateToNow();
        super.update(userToUpdate);
    }

    public InternalUser rename(User user, String newUsername) throws UserNotFoundException {
        InternalUser userToRename = this.findByName(user.getDirectoryId(), user.getName());
        String oldName = userToRename.getName();
        userToRename.renameTo(newUsername);
        userToRename.setUpdatedDateToNow();
        super.update(userToRename);
        this.internalMembershipDao.renameUserRelationships(userToRename.getDirectoryId(), oldName, userToRename.getName());
        return userToRename;
    }

    public void remove(User user) throws UserNotFoundException {
        final InternalUser userToRemove = this.findByName(user.getDirectoryId(), user.getName());
        this.internalMembershipDao.removeUserMemberships(user.getDirectoryId(), user.getName());
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeAllInternalUserAttributes").setEntity("user", (Object)userToRemove).executeUpdate();
            }
        });
        super.remove(userToRemove);
    }

    public void removeAll(final long directoryId) {
        this.internalMembershipDao.removeAllUserRelationships(directoryId);
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.getNamedQuery("removeInternalUserAttributesInDirectory").setLong("directoryId", directoryId).executeUpdate();
                session.getNamedQuery("removeCredentialRecordsInDirectory").setLong("directoryId", directoryId).executeUpdate();
                return session.getNamedQuery("removeInternalUsersInDirectory").setLong("directoryId", directoryId).executeUpdate();
            }
        });
    }

    public void storeAttributes(User user, Map<String, Set<String>> attributes) throws UserNotFoundException {
        InternalUser internalUser = this.findByName(user.getDirectoryId(), user.getName());
        Set<InternalUserAttribute> attributesList = this.findUserAttributes(internalUser.getId());
        HashMap<String, HashSet<InternalUserAttribute>> existingAttributesMap = new HashMap<String, HashSet<InternalUserAttribute>>();
        for (InternalUserAttribute internalUserAttribute : attributesList) {
            HashSet<InternalUserAttribute> existingVals = (HashSet<InternalUserAttribute>)existingAttributesMap.get(internalUserAttribute.getName());
            if (existingVals == null) {
                existingVals = new HashSet<InternalUserAttribute>();
                existingAttributesMap.put(internalUserAttribute.getName(), existingVals);
            }
            existingVals.add(internalUserAttribute);
        }
        for (Map.Entry entry : attributes.entrySet()) {
            if (existingAttributesMap.containsKey(entry.getKey())) {
                Set newVals = (Set)entry.getValue();
                Set existingVals = (Set)existingAttributesMap.get(entry.getKey());
                ArrayList<String> valsToAdd = new ArrayList<String>();
                HashSet valsToRemove = new HashSet(existingVals);
                for (String newVal : newVals) {
                    boolean valueAlreadyExists = false;
                    for (InternalUserAttribute existingVal : existingVals) {
                        if (!newVal.equals(existingVal.getValue())) continue;
                        valsToRemove.remove(existingVal);
                        valueAlreadyExists = true;
                        break;
                    }
                    if (valueAlreadyExists) continue;
                    valsToAdd.add(newVal);
                }
                for (InternalUserAttribute existingVal : valsToRemove) {
                    if (valsToAdd.size() > 0) {
                        String newVal = (String)valsToAdd.remove(0);
                        existingVal.setValue(newVal);
                        this.saveOrUpdate(existingVal);
                        continue;
                    }
                    this.remove(existingVal);
                }
                for (String newVal : valsToAdd) {
                    this.addAttribute(internalUser, (String)entry.getKey(), newVal);
                }
                continue;
            }
            for (String newVal : (Set)entry.getValue()) {
                this.addAttribute(internalUser, (String)entry.getKey(), newVal);
            }
        }
    }

    private void addAttribute(InternalUser user, String attributeName, String attributeValue) {
        InternalUserAttribute attribute = new InternalUserAttribute(user, attributeName, attributeValue);
        this.getHibernateTemplate().save((Object)attribute);
    }

    public void removeAttribute(User user, String attributeName) throws UserNotFoundException {
        this.removeAttributes(this.findByName(user.getDirectoryId(), user.getName()), attributeName);
    }

    private void removeAttributes(final InternalUser user, final String attributeName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeInternalUserAttributes").setEntity("user", (Object)user).setString("attributeName", attributeName).executeUpdate();
            }
        });
    }

    public <T> List<T> search(final long directoryID, final EntityQuery<T> query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.USER) {
            throw new IllegalArgumentException("UserDAO can only evaluate EntityQueries for Entity.USER");
        }
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                HQLQuery hqlQuery = UserDAOHibernate.this.hqlQueryTranslater.asHQL(directoryID, query);
                Query hibernateQuery = session.createQuery(hqlQuery.toString()).setFirstResult(query.getStartIndex());
                if (query.getMaxResults() != -1) {
                    hibernateQuery.setMaxResults(query.getMaxResults());
                }
                ListIterator iterator = hqlQuery.getParameterValues().listIterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    hibernateQuery.setParameter(iterator.previousIndex(), value);
                }
                return HibernateSearchResultsTransformer.transformResults((List)hibernateQuery.list());
            }
        });
    }

    public BatchResult<User> addAll(Set<UserTemplateWithCredentialAndAttributes> users) {
        HashSet<TransactionGroup> usersToAdd = new HashSet<TransactionGroup>();
        HashSet<UserTemplateWithCredentialAndAttributes> usersFailedValidation = new HashSet<UserTemplateWithCredentialAndAttributes>();
        for (UserTemplateWithCredentialAndAttributes user : users) {
            try {
                InternalUser userToAdd = new InternalUser((User)user, (Directory)this.getDirectory((User)user), user.getCredential());
                userToAdd.setCreatedDateToNow();
                userToAdd.setUpdatedDateToNow();
                HashSet<InternalUserAttribute> attribs = new HashSet<InternalUserAttribute>();
                for (Map.Entry entry : user.getAttributes().entrySet()) {
                    for (String value : (Set)entry.getValue()) {
                        attribs.add(new InternalUserAttribute(userToAdd, (String)entry.getKey(), value));
                    }
                }
                usersToAdd.add(new TransactionGroup((Serializable)userToAdd, attribs));
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Could not add user <" + user.getName() + ">: " + e.getMessage());
                usersFailedValidation.add(user);
            }
            catch (DirectoryNotFoundException e) {
                this.logger.error("Could not add user <" + user.getName() + ">: " + e.getMessage());
                usersFailedValidation.add(user);
            }
        }
        BatchResult daoResult = this.batchProcessor.execute((HibernateOperation)new MergeOperation(), usersToAdd);
        BatchResult result = new BatchResult(users.size());
        for (TransactionGroup transactionGroup : daoResult.getSuccessfulEntities()) {
            result.addSuccess((Object)transactionGroup.getPrimaryObject());
        }
        for (TransactionGroup transactionGroup : daoResult.getFailedEntities()) {
            result.addFailure((Object)transactionGroup.getPrimaryObject());
        }
        result.addFailures(usersFailedValidation);
        return result;
    }

    public void removeAllUsers(long directoryId, Set<String> userNames) {
        Collection<InternalUser> users = this.findByNames(directoryId, userNames);
        this.batchProcessor.execute((HibernateOperation)new RemoveUserOperation(), users);
    }

    public BatchResultWithIdReferences<User> addAll(Collection<UserTemplateWithCredentialAndAttributes> users) {
        HashSet<TransactionGroup> usersToAdd = new HashSet<TransactionGroup>();
        HashSet<UserTemplateWithCredentialAndAttributes> usersFailedValidation = new HashSet<UserTemplateWithCredentialAndAttributes>();
        for (UserTemplateWithCredentialAndAttributes user : users) {
            try {
                DirectoryImpl directory = (DirectoryImpl)this.directoryDAO.loadReference(user.getDirectoryId());
                InternalUser userToAdd = new InternalUser(user, (Directory)directory);
                HashSet<InternalUserAttribute> attribs = new HashSet<InternalUserAttribute>();
                for (Map.Entry entry : user.getAttributes().entrySet()) {
                    for (String value : (Set)entry.getValue()) {
                        attribs.add(new InternalUserAttribute(userToAdd, (String)entry.getKey(), value));
                    }
                }
                usersToAdd.add(new TransactionGroup((Serializable)userToAdd, attribs));
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Could not add user <" + user.getName() + ">: " + e.getMessage());
                usersFailedValidation.add(user);
            }
        }
        BatchResult daoResult = this.batchProcessor.execute((HibernateOperation)new MergeOperation(), usersToAdd);
        BatchResultWithIdReferences result = new BatchResultWithIdReferences(users.size());
        for (TransactionGroup transactionGroup : daoResult.getFailedEntities()) {
            result.addFailure((Object)transactionGroup.getPrimaryObject());
        }
        result.addFailures(usersFailedValidation);
        for (TransactionGroup user : usersToAdd) {
            result.addIdReference((InternalDirectoryEntity)user.getPrimaryObject());
        }
        return result;
    }

    public Collection<InternalUser> findByNames(long directoryID, Collection<String> usernames) {
        return this.batchFinder.find(directoryID, usernames, InternalUser.class);
    }

    public void setDirectoryDAO(DirectoryDAOHibernate directoryDAO) {
        this.directoryDAO = directoryDAO;
    }

    public void setMembershipDAO(InternalMembershipDao internalMembershipDao) {
        this.internalMembershipDao = internalMembershipDao;
    }

    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    public void setInternalAttributesHelper(InternalAttributesHelper internalAttributesHelper) {
        this.internalAttributesHelper = internalAttributesHelper;
    }
}

