/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.token;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.token.TokenDAO;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.orm.hibernate3.HibernateCallback;

public class TokenDAOHibernate
extends HibernateDao
implements TokenDAO {
    private HQLQueryTranslater hqlQueryTranslater;

    public Token findByRandomHash(final String randomHash) throws ObjectNotFoundException {
        Object result = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Criteria criteria = CriteriaFactory.createCriteria(session, TokenDAOHibernate.this.getPersistentClass());
                criteria.add((Criterion)Expression.eq((String)"randomHash", (Object)randomHash));
                return criteria.uniqueResult();
            }
        });
        if (result == null) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)randomHash);
        }
        return (Token)result;
    }

    public Token findByIdentifierHash(final String identifierHash) throws ObjectNotFoundException {
        Object result = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Criteria criteria = CriteriaFactory.createCriteria(session, TokenDAOHibernate.this.getPersistentClass());
                criteria.add((Criterion)Expression.eq((String)"identifierHash", (Object)identifierHash));
                return criteria.uniqueResult();
            }
        });
        if (result == null) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)identifierHash);
        }
        return (Token)result;
    }

    public Token add(Token token) {
        super.save(token);
        return token;
    }

    public Token update(Token token) {
        token.setLastAccessedDate(new Date());
        super.update(token);
        return token;
    }

    public void remove(Token token) {
        super.remove(token);
        this.getSessionFactory().getCurrentSession().flush();
    }

    public List<Token> search(final EntityQuery query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.TOKEN) {
            throw new IllegalArgumentException("TokenDAO can only evaluate EntityQueries for Entity.TOKEN");
        }
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                HQLQuery hqlQuery = TokenDAOHibernate.this.hqlQueryTranslater.asHQL(query);
                Query hibernateQuery = session.createQuery(hqlQuery.toString()).setFirstResult(query.getStartIndex());
                if (query.getMaxResults() != -1) {
                    hibernateQuery.setMaxResults(query.getMaxResults());
                }
                ListIterator iterator = hqlQuery.getParameterValues().listIterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    hibernateQuery.setParameter(iterator.previousIndex(), value);
                }
                return HibernateSearchResultsTransformer.transformResults((List)hibernateQuery.list());
            }
        });
    }

    public Token findByID(long ID) throws ObjectNotFoundException {
        return (Token)this.load(ID);
    }

    public void remove(final long directoryId, final String name) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.getNamedQuery("removeTokensByDirectoryAndName");
                query.setLong("directoryId", directoryId);
                query.setString("name", name);
                return query.executeUpdate();
            }
        });
    }

    public void removeAll(final long directoryId) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.getNamedQuery("removeTokensByDirectory");
                query.setLong("directoryId", directoryId);
                return query.executeUpdate();
            }
        });
    }

    @Override
    public Class getPersistentClass() {
        return Token.class;
    }

    public Collection<Token> loadAll() {
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return CriteriaFactory.createCriteria(session, TokenDAOHibernate.this.getPersistentClass()).list();
            }
        });
    }

    public void saveAll(Collection<Token> tokens) {
        if (tokens == null) {
            throw new DataRetrievalFailureException("Unable to save an empty collection of tokens");
        }
        for (Token token : tokens) {
            this.save(token);
        }
    }

    public void removeAll() {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeAllTokens").executeUpdate();
            }
        });
    }

    public void removeAccessedBefore(final Date expiryTime) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeTokensAccessedBefore").setDate("expiryDate", expiryTime).executeUpdate();
            }
        });
    }

    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }
}

