/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.directory;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.group.InternalGroupDao;
import com.atlassian.crowd.dao.user.InternalUserDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import java.sql.SQLException;
import java.util.List;
import java.util.ListIterator;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;

public class DirectoryDAOHibernate
extends HibernateDao
implements DirectoryDao {
    private InternalUserDao internalUserDao;
    private InternalGroupDao internalGroupDao;
    private HQLQueryTranslater hqlQueryTranslater;

    @Override
    public Class getPersistentClass() {
        return DirectoryImpl.class;
    }

    public DirectoryImpl findById(long id) throws DirectoryNotFoundException {
        try {
            return (DirectoryImpl)this.load(id);
        }
        catch (ObjectNotFoundException e) {
            throw new DirectoryNotFoundException(Long.valueOf(id));
        }
    }

    public DirectoryImpl findByName(final String name) throws DirectoryNotFoundException {
        Object result = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return CriteriaFactory.createCriteria(session, DirectoryDAOHibernate.this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"lowerName", (Object)IdentifierUtils.toLowerCase((String)name))).uniqueResult();
            }
        });
        if (result == null) {
            throw new DirectoryNotFoundException(name);
        }
        return (DirectoryImpl)result;
    }

    public List<Directory> findAll() {
        return this.getHibernateTemplate().find("from DirectoryImpl");
    }

    public DirectoryImpl add(Directory directory) {
        DirectoryImpl directoryToPersist = new DirectoryImpl(directory);
        directoryToPersist.setCreatedDateToNow();
        directoryToPersist.setUpdatedDateToNow();
        directoryToPersist.validate();
        super.save(directoryToPersist);
        return directoryToPersist;
    }

    public DirectoryImpl update(Directory directory) throws DirectoryNotFoundException {
        DirectoryImpl directoryToUpdate = this.findById(directory.getId());
        directoryToUpdate.setUpdatedDateToNow();
        directoryToUpdate.updateDetailsFrom(directory);
        directoryToUpdate.validate();
        super.update(directoryToUpdate);
        return directoryToUpdate;
    }

    public void remove(Directory directory) throws DirectoryNotFoundException {
        this.internalGroupDao.removeAll(directory.getId().longValue());
        this.internalUserDao.removeAll(directory.getId().longValue());
        super.remove(directory);
    }

    public List<Directory> search(final EntityQuery query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.DIRECTORY) {
            throw new IllegalArgumentException("DirectoryDAO can only evaluate EntityQueries for Entity.DIRECTORY");
        }
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                HQLQuery hqlQuery = DirectoryDAOHibernate.this.hqlQueryTranslater.asHQL(query);
                Query hibernateQuery = session.createQuery(hqlQuery.toString()).setFirstResult(query.getStartIndex());
                if (query.getMaxResults() != -1) {
                    hibernateQuery.setMaxResults(query.getMaxResults());
                }
                ListIterator iterator = hqlQuery.getParameterValues().listIterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    hibernateQuery.setParameter(iterator.previousIndex(), value);
                }
                return HibernateSearchResultsTransformer.transformResults((List)hibernateQuery.list());
            }
        });
    }

    public void setUserDAO(InternalUserDao internalUserDao) {
        this.internalUserDao = internalUserDao;
    }

    public void setGroupDAO(InternalGroupDao internalGroupDao) {
        this.internalGroupDao = internalGroupDao;
    }

    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }
}

