/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.directory;

import com.atlassian.crowd.dao.directory.ImmutableDirectory;
import com.atlassian.crowd.dao.directory.SortedProperties;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryPropertiesMapper {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryPropertiesMapper.class);
    public static final String IMPLEMENTATION_CLASS_PROPERTY = "implementationClass";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String ENCRYPTION_TYPE_PROPERTY = "encryptionType";
    public static final String ACTIVE_PROPERTY = "active";
    public static final String NAME_PROPERTY = "name";
    public static final String ATTRIBUTES_PROPERTY = "attributes";
    public static final String TYPE_PROPERTY = "type";
    public static final String ALLOWED_OPERATIONS_PROPERTY = "allowedOperations";

    public Directory importDirectory(Properties properties, Long id, Date timestamp) throws DirectoryNotFoundException {
        if (this.canImportDirectory(id)) {
            ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder();
            builder.setId(id);
            builder.setName(this.getDirectoryName(properties, id));
            builder.setDescription(this.getDirectoryDescription(properties, id));
            builder.setActive(this.getIsActiveDirectory(properties, id));
            builder.setType(this.getDirectoryType(properties, id));
            builder.setAllowedOperations(this.getDirectoryAllowedOperations(properties, id));
            builder.setEncryptionType(this.getDirectoryEncryptionType(properties, id));
            builder.setImplementationClass(this.getDirectoryImplementationClass(properties, id));
            builder.setCreatedDate(timestamp);
            builder.setUpdatedDate(timestamp);
            builder.setAttributes(this.getDirectoryAttributes(properties, id));
            return builder.toDirectory();
        }
        logger.info("Instantiation of directory {} from property file is not permitted", (Object)id);
        throw new DirectoryNotFoundException(id);
    }

    protected boolean canImportDirectory(Long id) {
        return true;
    }

    private String getPropertyName(Long id, String propertyName) {
        return "directory." + id + "." + propertyName;
    }

    private String getRequiredPropertyStringValueOrFail(Properties properties, Long id, String unqualifiedPropertyName) throws DirectoryNotFoundException {
        String value = properties.getProperty(this.getPropertyName(id, unqualifiedPropertyName));
        if (value == null) {
            logger.error("Directory {} is missing required property '{}'", (Object)id, (Object)unqualifiedPropertyName);
            throw new DirectoryNotFoundException(id);
        }
        return value;
    }

    private String getOptionalPropertyStringValue(Properties properties, Long id, String unqualifiedPropertyName) {
        return properties.getProperty(this.getPropertyName(id, unqualifiedPropertyName));
    }

    private String getDirectoryName(Properties properties, Long id) throws DirectoryNotFoundException {
        return this.getRequiredPropertyStringValueOrFail(properties, id, NAME_PROPERTY);
    }

    private boolean getIsActiveDirectory(Properties properties, Long id) throws DirectoryNotFoundException {
        return Boolean.valueOf(this.getRequiredPropertyStringValueOrFail(properties, id, ACTIVE_PROPERTY));
    }

    private String getDirectoryEncryptionType(Properties properties, Long id) throws DirectoryNotFoundException {
        return this.getOptionalPropertyStringValue(properties, id, ENCRYPTION_TYPE_PROPERTY);
    }

    private String getDirectoryDescription(Properties properties, Long id) throws DirectoryNotFoundException {
        return this.getRequiredPropertyStringValueOrFail(properties, id, DESCRIPTION_PROPERTY);
    }

    private String getDirectoryImplementationClass(Properties properties, Long id) throws DirectoryNotFoundException {
        return this.getRequiredPropertyStringValueOrFail(properties, id, IMPLEMENTATION_CLASS_PROPERTY);
    }

    private DirectoryType getDirectoryType(Properties properties, Long id) throws DirectoryNotFoundException {
        try {
            return DirectoryType.valueOf((String)this.getRequiredPropertyStringValueOrFail(properties, id, TYPE_PROPERTY));
        }
        catch (IllegalArgumentException e) {
            throw new DirectoryNotFoundException("Unknown directory type", (Throwable)e);
        }
    }

    public Map<String, String> getDirectoryAttributes(Properties properties, Long id) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String propertyPrefix = this.getPropertyName(id, ATTRIBUTES_PROPERTY) + ".";
        for (String propertyName : properties.stringPropertyNames()) {
            if (!propertyName.startsWith(propertyPrefix)) continue;
            builder.put((Object)propertyName.substring(propertyPrefix.length()), (Object)properties.getProperty(propertyName));
        }
        return builder.build();
    }

    private Set<OperationType> getDirectoryAllowedOperations(Properties properties, Long id) throws DirectoryNotFoundException {
        String commaSeparatedOperationNames = this.getRequiredPropertyStringValueOrFail(properties, id, ALLOWED_OPERATIONS_PROPERTY);
        Iterable operationNames = Splitter.on((char)',').trimResults().split((CharSequence)commaSeparatedOperationNames);
        try {
            return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)operationNames, (Function)new Function<String, OperationType>(){

                public OperationType apply(String input) {
                    return OperationType.valueOf((String)input);
                }
            }));
        }
        catch (IllegalArgumentException e) {
            throw new DirectoryNotFoundException("Unknown operation type", (Throwable)e);
        }
    }

    public List<Directory> importAllDirectories(Properties properties, Date timestamp) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Long id : this.findAllIds(properties)) {
            try {
                builder.add((Object)this.importDirectory(properties, id, timestamp));
            }
            catch (DirectoryNotFoundException e) {
                logger.info("Skipping directory {} from the configuration file", (Object)id);
            }
        }
        return builder.build();
    }

    private Set<Long> findAllIds(Properties properties) {
        Pattern propertyNamePattern = Pattern.compile("^directory\\.([0-9]+)\\..*$");
        ImmutableSet.Builder directoryIds = ImmutableSet.builder();
        for (String propertyName : properties.stringPropertyNames()) {
            Matcher matcher = propertyNamePattern.matcher(propertyName);
            if (!matcher.find()) continue;
            directoryIds.add((Object)Long.parseLong(matcher.group(1)));
        }
        return directoryIds.build();
    }

    public Properties exportProperties(Iterable<Directory> allDirectories) {
        SortedProperties properties = new SortedProperties();
        for (Directory directory : allDirectories) {
            properties.setProperty(this.getPropertyName(directory.getId(), NAME_PROPERTY), directory.getName());
            properties.setProperty(this.getPropertyName(directory.getId(), ACTIVE_PROPERTY), Boolean.toString(directory.isActive()));
            properties.setProperty(this.getPropertyName(directory.getId(), DESCRIPTION_PROPERTY), directory.getDescription());
            properties.setProperty(this.getPropertyName(directory.getId(), TYPE_PROPERTY), directory.getType().toString());
            properties.setProperty(this.getPropertyName(directory.getId(), IMPLEMENTATION_CLASS_PROPERTY), directory.getImplementationClass());
            properties.setProperty(this.getPropertyName(directory.getId(), ALLOWED_OPERATIONS_PROPERTY), Joiner.on((String)",").join((Iterable)ImmutableSortedSet.copyOf((Collection)directory.getAllowedOperations())));
            for (Map.Entry attributeEntry : directory.getAttributes().entrySet()) {
                properties.setProperty(this.getPropertyName(directory.getId(), "attributes." + (String)attributeEntry.getKey()), (String)attributeEntry.getValue());
            }
            if (directory.getEncryptionType() == null) continue;
            properties.setProperty(this.getPropertyName(directory.getId(), ENCRYPTION_TYPE_PROPERTY), directory.getEncryptionType());
        }
        return properties;
    }
}

