/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy.database;

import java.lang.reflect.Field;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.connection.C3P0ConnectionProvider;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.DatasourceConnectionProvider;
import org.hibernate.engine.SessionFactoryImplementor;
import org.springframework.beans.factory.FactoryBean;

public class HibernateDataSourceAccessor
implements FactoryBean {
    private final SessionFactory sessionFactory;

    public HibernateDataSourceAccessor(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Object getObject() throws Exception {
        if (this.sessionFactory instanceof SessionFactoryImplementor) {
            ConnectionProvider cp = ((SessionFactoryImplementor)this.sessionFactory).getConnectionProvider();
            if (cp instanceof C3P0ConnectionProvider) {
                Field dsField = C3P0ConnectionProvider.class.getDeclaredField("ds");
                dsField.setAccessible(true);
                return dsField.get(cp);
            }
            if (cp instanceof DatasourceConnectionProvider) {
                Field dsField = DatasourceConnectionProvider.class.getDeclaredField("ds");
                dsField.setAccessible(true);
                return dsField.get(cp);
            }
        }
        return null;
    }

    public Class getObjectType() {
        return DataSource.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

