/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy;

import com.atlassian.crowd.integration.model.InternalEntityTemplate;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.group.InternalGroup;
import com.atlassian.crowd.integration.model.group.InternalGroupWithAttributes;
import com.atlassian.crowd.integration.model.membership.InternalMembership;
import com.atlassian.crowd.integration.model.membership.MembershipType;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.GenericLegacyImporter;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.LegacyImporter;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.model.group.GroupDAOHibernate;
import com.atlassian.crowd.model.membership.MembershipDAOHibernate;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResultWithIdReferences;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.hibernate.SessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleMapper
extends GenericLegacyImporter
implements LegacyImporter {
    public static final String REMOTE_ROLE_XML_ROOT = "roles";
    public static final String REMOTE_ROLE_XML_PRINCIPAL_DIRECTORY_ID = "directoryId";
    public static final String REMOTE_ROLE_XML_DIRECTORY_ID = "directoryId";
    public static final String REMOTE_ROLE_XML_DESCRIPTION = "description";
    public static final String REMOTE_ROLE_XML_PRINCIPAL_NODE = "principals";
    public static final String REMOTE_ROLE_XML_PRINCIPAL = "principal";
    private final GroupDAOHibernate groupDAO;
    private final MembershipDAOHibernate membershipDAO;
    private final DirectoryDAOHibernate directoryDAO;

    public RoleMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, GroupDAOHibernate groupDAO, MembershipDAOHibernate membershipDAO, DirectoryDAOHibernate directoryDAO) {
        super(sessionFactory, batchProcessor);
        this.groupDAO = groupDAO;
        this.membershipDAO = membershipDAO;
        this.directoryDAO = directoryDAO;
    }

    @Override
    public void importXml(Element root, LegacyImportDataHolder importData) throws ImportException {
        Element rolesElement = (Element)root.selectSingleNode("/crowd/ roles");
        if (rolesElement == null) {
            this.logger.error((Object)"No roles were found for importing!");
            return;
        }
        ArrayList<InternalGroupWithAttributes> roles = new ArrayList<InternalGroupWithAttributes>();
        Iterator remoteRoles = rolesElement.elementIterator();
        while (remoteRoles.hasNext()) {
            Element roleElement = (Element)remoteRoles.next();
            InternalGroupWithAttributes role = this.getRoleAndAttributesFromXml(roleElement, importData.getOldToNewDirectoryIds());
            roles.add(role);
        }
        BatchResultWithIdReferences roleImportResults = this.groupDAO.addAll(roles);
        for (InternalGroupWithAttributes role : roleImportResults.getFailedEntities()) {
            this.logger.error((Object)("Unable to add role <" + role.getName() + "> in directory with id <" + role.getDirectoryId() + ">"));
        }
        if (roleImportResults.hasFailures()) {
            throw new ImportException("Unable to import all roles. See logs for more details.");
        }
        Iterator remoteRoles2 = rolesElement.elementIterator();
        while (remoteRoles2.hasNext()) {
            Element roleElement = (Element)remoteRoles2.next();
            Set<InternalMembership> memberships = this.getMemberships(roleElement, importData, (BatchResultWithIdReferences<Group>)roleImportResults);
            BatchResult membershipResult = this.membershipDAO.addAll(memberships);
            for (InternalMembership membership : membershipResult.getFailedEntities()) {
                this.logger.error((Object)("Unable to add user <" + membership.getChildName() + "> to role <" + membership.getParentName() + "> in directory with id <" + membership.getDirectory().getId() + ">"));
            }
            if (!membershipResult.hasFailures()) continue;
            throw new ImportException("Unable to import all memberships. See logs for more details.");
        }
    }

    protected InternalGroupWithAttributes getRoleAndAttributesFromXml(Element roleElement, Map<Long, Long> oldToNewDirectoryIds) {
        Long oldDirectoryId = Long.parseLong(roleElement.element("directoryId").getText());
        Long directoryId = oldToNewDirectoryIds.get(oldDirectoryId);
        if (directoryId == null) {
            throw new IllegalArgumentException("Role belongs to an unknown old directory with ID: " + directoryId);
        }
        Directory directory = (Directory)this.directoryDAO.loadReference(directoryId.longValue());
        InternalEntityTemplate internalEntityTemplate = this.getInternalEntityTemplateFromLegacyXml(roleElement);
        internalEntityTemplate.setName(internalEntityTemplate.getName());
        internalEntityTemplate.setId(null);
        GroupTemplate roleTemplate = new GroupTemplate(internalEntityTemplate.getName(), directory.getId(), GroupType.LEGACY_ROLE);
        roleTemplate.setActive(internalEntityTemplate.isActive());
        String description = "";
        Element descriptionElement = roleElement.element(REMOTE_ROLE_XML_DESCRIPTION);
        if (descriptionElement != null && descriptionElement.hasContent()) {
            description = descriptionElement.getText();
        }
        roleTemplate.setDescription(description);
        InternalGroup role = new InternalGroup(internalEntityTemplate, directory, roleTemplate);
        Map<String, List<String>> attributes = this.getMultiValuedAttributesMapFromXml(roleElement);
        return new InternalGroupWithAttributes(role, attributes);
    }

    protected Set<InternalMembership> getMemberships(Element roleElement, LegacyImportDataHolder importData, BatchResultWithIdReferences<Group> roleImportResults) {
        String roleName = roleElement.element("name").getText();
        Long oldDirectoryId = Long.parseLong(roleElement.element("directoryId").getText());
        Long directoryId = importData.getOldToNewDirectoryIds().get(oldDirectoryId);
        if (directoryId == null) {
            throw new IllegalArgumentException("Role belongs to an unknown old directory with ID: " + directoryId);
        }
        Directory directory = (Directory)this.directoryDAO.loadReference(directoryId.longValue());
        Long roleId = roleImportResults.getIdReference(directoryId, roleName);
        HashSet<InternalMembership> memberships = new HashSet<InternalMembership>();
        Element membersElement = roleElement.element(REMOTE_ROLE_XML_PRINCIPAL_NODE);
        if (membersElement != null && membersElement.hasContent()) {
            Iterator iterator = membersElement.elementIterator(REMOTE_ROLE_XML_PRINCIPAL);
            while (iterator.hasNext()) {
                Element memberElement = (Element)iterator.next();
                String memberName = memberElement.attributeValue("name");
                Long userId = importData.getUserImportResults().getIdReference(directoryId, memberName);
                InternalMembership membership = new InternalMembership(null, roleId, userId, MembershipType.GROUP_USER, GroupType.LEGACY_ROLE, roleName, memberName, directory);
                memberships.add(membership);
            }
        }
        return memberships;
    }
}

