/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.mapper;

import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.directory.ldap.mapper.ContextMapperWithCustomAttributes;
import com.atlassian.crowd.directory.ldap.mapper.NameAttributesPair;
import com.atlassian.crowd.directory.ldap.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.directory.ldap.mapper.entity.LDAPUserAttributesMapper;
import com.atlassian.crowd.directory.ldap.name.CrowdLdapName;
import com.atlassian.crowd.directory.ldap.util.DNStandardiser;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import java.util.List;
import java.util.Set;
import javax.naming.directory.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.ldap.NamingException;

public class UserContextMapper
extends ContextMapperWithCustomAttributes<LDAPUserWithAttributes> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final long directoryId;
    protected final LDAPPropertiesMapper ldapPropertiesMapper;

    public UserContextMapper(long directoryId, LDAPPropertiesMapper ldapPropertiesMapper, List<AttributeMapper> customAttributeMappers) {
        super(customAttributeMappers);
        this.directoryId = directoryId;
        this.ldapPropertiesMapper = ldapPropertiesMapper;
    }

    @Override
    protected Set<String> getCoreRequiredLdapAttributes() {
        return this.getAttributesMapper().getRequiredLdapAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPUserWithAttributes mapFromContext(NameAttributesPair nameAttributesPair) throws NamingException {
        UserTemplateWithAttributes userTemplate;
        Attributes attributes = nameAttributesPair.getAttributes();
        LDAPUserAttributesMapper mapper = this.getAttributesMapper();
        MDC.put((String)"crowd.ldap.context", (String)nameAttributesPair.getName().toString());
        try {
            userTemplate = mapper.mapUserFromAttributes(attributes);
        }
        finally {
            MDC.remove((String)"crowd.ldap.context");
        }
        for (AttributeMapper attributeMapper : this.customAttributeMappers) {
            try {
                userTemplate.setAttribute(attributeMapper.getKey(), attributeMapper.getValues(nameAttributesPair));
            }
            catch (Exception e) {
                this.logger.warn("Failed to map attribute <" + attributeMapper.getKey() + "> from context with DN <" + nameAttributesPair.getName().toString() + ">", (Throwable)e);
            }
        }
        CrowdLdapName ldapName = DNStandardiser.ensureNameIsStandardised(nameAttributesPair.getName(), !this.ldapPropertiesMapper.isRelaxedDnStandardisation());
        LDAPUserWithAttributes user = new LDAPUserWithAttributes(ldapName, userTemplate);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Created user <" + String.valueOf(user) + "> from DN <" + String.valueOf(nameAttributesPair.getName()) + ">");
        }
        return user;
    }

    protected LDAPUserAttributesMapper getAttributesMapper() {
        return new LDAPUserAttributesMapper(this.directoryId, this.ldapPropertiesMapper);
    }
}

