/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.mapper;

import com.atlassian.crowd.directory.ldap.name.CrowdLdapName;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.springframework.ldap.support.LdapUtils;

public class NameAttributesPair {
    private final CrowdLdapName name;
    private final Attributes attributes;

    public NameAttributesPair(@Nonnull CrowdLdapName name, @Nonnull Attributes attributes) {
        this.name = (CrowdLdapName)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.attributes = this.copyAttributesWithIgnoredCase(attributes);
    }

    private Attributes copyAttributesWithIgnoredCase(@Nonnull Attributes attributes) {
        Preconditions.checkNotNull((Object)attributes, (Object)"attributes cannot be null");
        BasicAttributes lowerAttrs = new BasicAttributes(true);
        NamingEnumeration<? extends Attribute> allAttrs = attributes.getAll();
        while (allAttrs.hasMoreElements()) {
            Attribute attr = (Attribute)allAttrs.nextElement();
            lowerAttrs.put(attr);
        }
        return lowerAttrs;
    }

    public CrowdLdapName getName() {
        return this.name;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getStringAttribute(String name) {
        return (String)this.getObjectAttribute(name);
    }

    public Object getObjectAttribute(String name) {
        Attribute singleAttr = this.attributes.get(name);
        if (singleAttr == null || singleAttr.size() == 0) {
            return null;
        }
        try {
            return singleAttr.get();
        }
        catch (NamingException ne) {
            throw LdapUtils.convertLdapException((NamingException)ne);
        }
    }

    public List<String> getAttributeValuesForName(String name) {
        Attribute singleAttr = this.attributes.get(name);
        if (singleAttr == null) {
            return null;
        }
        if (singleAttr.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(singleAttr.size());
        if (singleAttr instanceof Iterable) {
            for (Object obj : (Iterable)((Object)singleAttr)) {
                list.add((String)obj);
            }
        } else {
            for (int idx = 0; idx < singleAttr.size(); ++idx) {
                try {
                    list.add((String)singleAttr.get(idx));
                    continue;
                }
                catch (NamingException ne) {
                    throw LdapUtils.convertLdapException((NamingException)ne);
                }
            }
        }
        return list;
    }

    public String toString() {
        return NameAttributesPair.class.getSimpleName() + ": " + String.valueOf(this.name);
    }
}

