/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.synchronisation.cache;

import com.atlassian.crowd.common.properties.SystemProperties;
import com.atlassian.crowd.directory.ldap.mapper.attribute.SIDUtils;
import com.atlassian.crowd.directory.ldap.name.CrowdLdapName;
import com.atlassian.crowd.directory.ldap.name.CrowdLdapNameFactory;
import com.atlassian.crowd.model.LDAPDirectoryEntity;
import com.atlassian.crowd.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupUserCache {
    private static final boolean IS_CACHE_DISABLED = (Boolean)SystemProperties.AD_GROUP_USER_CACHE_DISABLED.getValue();
    private static final Logger log = LoggerFactory.getLogger(GroupUserCache.class);
    private final CrowdLdapNameFactory ldapNameFactory = CrowdLdapNameFactory.getInstance();
    private final boolean containsAllGroupsAndUsers;
    private final boolean groupsContainUserMembership;
    private final boolean usersContainGroupMembership;
    private final Collection<LDAPUserWithAttributes> retrievedUsers;
    private final Map<CrowdLdapName, LDAPGroupWithAttributes> nameToRetrievedGroupMap;
    private Map<String, List<CrowdLdapName>> primaryGroupRidToMembersMap;
    private Map<CrowdLdapName, List<CrowdLdapName>> userGroupToMembersMap;

    public static GroupUserCache createEmptyCache() {
        return new GroupUserCache(false, false, false, Collections.emptyList(), Collections.emptyList());
    }

    public GroupUserCache(boolean containsAllGroupsAndUsers, boolean groupsContainUserMembership, boolean usersContainGroupMembership, Collection<LDAPGroupWithAttributes> retrievedGroups, Collection<LDAPUserWithAttributes> retrievedUsers) {
        this.containsAllGroupsAndUsers = containsAllGroupsAndUsers;
        this.groupsContainUserMembership = groupsContainUserMembership;
        this.usersContainGroupMembership = usersContainGroupMembership;
        this.retrievedUsers = ImmutableList.copyOf(retrievedUsers);
        this.nameToRetrievedGroupMap = retrievedGroups.stream().collect(Collectors.toMap(LDAPDirectoryEntity::getLdapName, e -> e));
    }

    public Optional<LDAPGroupWithAttributes> getGroupWithUserMembership(CrowdLdapName groupDn) {
        if (!this.groupsContainUserMembership || IS_CACHE_DISABLED) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.nameToRetrievedGroupMap.get(groupDn));
    }

    @Nullable
    public Iterable<CrowdLdapName> getUsersByUserGroupMembership(CrowdLdapName groupDn) {
        List<CrowdLdapName> users;
        if (!this.containsAllGroupsAndUsers || !this.usersContainGroupMembership || IS_CACHE_DISABLED) {
            return null;
        }
        if (this.userGroupToMembersMap == null) {
            this.userGroupToMembersMap = this.calcUserGroupToMembersMap();
        }
        return (users = this.userGroupToMembersMap.get(groupDn)) == null ? Collections.emptyList() : ImmutableList.copyOf(users);
    }

    private Map<CrowdLdapName, List<CrowdLdapName>> calcUserGroupToMembersMap() {
        HashMap<CrowdLdapName, List<CrowdLdapName>> groupToNamesMap = new HashMap<CrowdLdapName, List<CrowdLdapName>>();
        for (LDAPUserWithAttributes user : this.retrievedUsers) {
            CrowdLdapName userLdapName = user.getLdapName();
            for (String groupDn : user.getValues("memberOf")) {
                CrowdLdapName groupName = this.ldapNameFactory.get(groupDn);
                groupToNamesMap.computeIfAbsent(groupName, k -> new ArrayList()).add(userLdapName);
            }
        }
        if (log.isInfoEnabled()) {
            log.info("Calculated overall group membership using user's memberOf: totalUsers: " + this.retrievedUsers.size() + ", totalReferencedGroups: " + groupToNamesMap.size());
        }
        return groupToNamesMap;
    }

    @Nullable
    public Iterable<CrowdLdapName> findUserMembersNamesOfGroupViaPrimaryGroupId(String primaryGroupRid) {
        List<CrowdLdapName> users;
        if (!this.containsAllGroupsAndUsers || IS_CACHE_DISABLED) {
            return null;
        }
        if (this.primaryGroupRidToMembersMap == null) {
            this.primaryGroupRidToMembersMap = this.calcPrimaryGroupRidToMembersMap();
        }
        return (users = this.primaryGroupRidToMembersMap.get(primaryGroupRid)) == null ? Collections.emptyList() : ImmutableList.copyOf(users);
    }

    private Map<String, List<CrowdLdapName>> calcPrimaryGroupRidToMembersMap() {
        HashMap<String, List<CrowdLdapName>> ridToNamesMap = new HashMap<String, List<CrowdLdapName>>();
        int usersWithPrimaryGroupCount = 0;
        for (LDAPUserWithAttributes user : this.retrievedUsers) {
            Optional<String> userPrimaryGroupId = SIDUtils.getPrimaryGroupSidOfUser(user);
            if (!userPrimaryGroupId.isPresent()) continue;
            ++usersWithPrimaryGroupCount;
            ridToNamesMap.computeIfAbsent(userPrimaryGroupId.get(), k -> new ArrayList()).add(user.getLdapName());
        }
        if (log.isInfoEnabled()) {
            log.info("Calculated overall additional group membership using user's primaryGroupId: totalUsers: " + this.retrievedUsers.size() + ", usersWithPrimaryGroup: " + usersWithPrimaryGroupCount + ", uniquePrimaryGroups: " + ridToNamesMap.size());
        }
        return ridToNamesMap;
    }
}

