package com.atlassian.crowd.search.ldap.test;

import java.util.List;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.search.builder.QueryBuilder;

public class LDAPConfigurationTesterImpl implements LDAPConfigurationTester {
    @Override
    public boolean canFindLdapObjects(RemoteDirectory remoteDirectory, Strategy strategy) throws OperationFailedException {
        final List<String> results = strategy.search(remoteDirectory.getAuthoritativeDirectory(), QueryBuilder.queryFor(String.class, strategy.getEntityDescriptor()).returningAtMost(1));
        return !results.isEmpty();
    }
}
