package com.atlassian.crowd.model;

import java.io.Serializable;

import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

import com.atlassian.crowd.embedded.api.Attributes;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public interface LDAPDirectoryEntity extends DirectoryEntity, Attributes, Serializable {
    /**
     * Gets the <b>standardised</b> distinguished name for the LDAP entity.
     *
     * @return distinguished name.
     */
    String getDn();


    @SuppressFBWarnings(value = "LDAP_INJECTION", justification = "No user input - the String was just retrieved from the LdapName")
    default LdapName getLdapName() {
        try {
            return new LdapName(getDn());
        } catch (InvalidNameException e) {
            // we just created the dn string from the ldap name, so shouldn't really happen
            throw new RuntimeException("Unable to parse DN for entity", e);
        }
    }
}
