package com.atlassian.crowd.directory.synchronisation.cache;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresherFactory;
import com.atlassian.crowd.directory.ldap.cache.EventTokenChangedCacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.RemoteDirectoryCacheRefresher;


/**
 * Default {@link CacheRefresherFactory} that can be used for Embedded Crowd.
 * Note that this implementation does not support AzureAdDirectory.
 *
 * @since 4.0.0
 */
@ExperimentalApi
public class CacheRefresherFactoryImpl implements CacheRefresherFactory {
    @Override
    public CacheRefresher createRefresher(RemoteDirectory remoteDirectory) {
        // If we are connected to AD, then we get a special CacheRefresher that uses the USNChanged value.
        if (remoteDirectory instanceof MicrosoftActiveDirectory) {
            return new UsnChangedCacheRefresher((MicrosoftActiveDirectory) remoteDirectory);
        }

        if (remoteDirectory instanceof RemoteCrowdDirectory) {
            final RemoteDirectoryCacheRefresher fullSyncCacheRefresher = new RemoteDirectoryCacheRefresher(remoteDirectory);
            return new EventTokenChangedCacheRefresher((RemoteCrowdDirectory) remoteDirectory, fullSyncCacheRefresher);
        }

        return new RemoteDirectoryCacheRefresher(remoteDirectory);
    }
}
