package com.atlassian.crowd.directory.synchronisation.cache;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class ActiveDirectoryTokenHolder {

    @JsonProperty("invocationId")
    private final String invocationId;

    @JsonProperty("lastUsnChanged")
    private final long lastUsnChanged;

    @JsonCreator
    public ActiveDirectoryTokenHolder(@JsonProperty("invocationId") String invocationId, @JsonProperty("lastUsnChanged") long lastUsnChanged) {
        this.invocationId = invocationId;
        this.lastUsnChanged = lastUsnChanged;
    }

    public String getInvocationId() {
        return invocationId;
    }

    public long getLastUsnChanged() {
        return lastUsnChanged;
    }
}
