package com.atlassian.crowd.directory.ssl;

import org.springframework.ldap.core.support.AbstractTlsDirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.DefaultTlsDirContextAuthenticationStrategy;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;

/**
 * This authentication strategy is replacement for {@link DefaultTlsDirContextAuthenticationStrategy},
 * and is a workaround for bug affecting JDK9-JDK13. Bug is fixed in JDK14.
 * https://bugs.java.com/bugdatabase/view_bug.do?bug_id=8217606
 * https://github.com/spring-projects/spring-ldap/issues/502
 * <p>
 * {@link DefaultTlsDirContextAuthenticationStrategy} initiates ssl connection and then performs an authentication.
 * At the end of the authentication process {@link LdapContext#reconnect(Control[])} is called.
 * This call in JDK9-JDK13 creates new non-ssl connection, and replaces previously created ssl connection.
 * This is a security vulnerability.
 */
public class CrowdTlsDirContextAuthenticationStrategy extends AbstractTlsDirContextAuthenticationStrategy {
    static final String SIMPLE_AUTHENTICATION = "simple";

    @Override
    public void applyAuthentication(LdapContext ctx, String userDn, String password) throws NamingException {
        ctx.addToEnvironment(Context.SECURITY_AUTHENTICATION, SIMPLE_AUTHENTICATION);
        ctx.addToEnvironment(Context.SECURITY_PRINCIPAL, userDn);
        ctx.addToEnvironment(Context.SECURITY_CREDENTIALS, password);

        // calling this will also perform an authentication
        ctx.lookup("");
    }
}
