package com.atlassian.crowd.directory.rfc4519;


import com.atlassian.crowd.directory.RFC4519Directory;
import com.atlassian.crowd.directory.ldap.mapper.ContextMapperWithRequiredAttributes;

import javax.naming.ldap.LdapName;
import java.util.List;
import java.util.Map;

/**
 * An iterable over RFC4519 directory memberships that assumes that it was supplied a complete list of users and groups
 * in the remote directory. No lookups for children objects that were not found in the cache will be performed.
 */
public class RFC4519DirectoryMembershipsIterableWithFullCache extends RFC4519DirectoryMembershipsIterable {
    RFC4519DirectoryMembershipsIterableWithFullCache(RFC4519Directory connector,
                                                     Map<LdapName, String> users,
                                                     Map<LdapName, String> groups,
                                                     Map<LdapName, String> groupsToInclude,
                                                     int membershipBatchSize,
                                                     ContextMapperWithRequiredAttributes<LdapName> dnMapper) {
        super(connector, users, groups, groupsToInclude, membershipBatchSize, dnMapper);
    }

    @Override
    protected void lookupMissingNames(List<MembershipHolder> memberships) {
    }
}
