package com.atlassian.crowd.directory.loader;

import java.util.Map;

import com.atlassian.crowd.directory.LDAPDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.event.api.EventPublisher;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Loads an implementation of a {@link com.atlassian.crowd.directory.RemoteDirectory} for use at runtime
 * by the Crowd security server.
 */
public class LDAPDirectoryInstanceLoaderImpl extends AbstractDirectoryInstanceLoader implements LDAPDirectoryInstanceLoader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private final InstanceFactory instanceFactory;

    public LDAPDirectoryInstanceLoaderImpl(final InstanceFactory instanceFactory) {
        this.instanceFactory = checkNotNull(instanceFactory);
    }

    public RemoteDirectory getRawDirectory(Long id, String className, Map<String, String> attributes) throws DirectoryInstantiationException {
        return RemoteDirectoryInstanceFactoryUtil.newRemoteDirectory(instanceFactory, id, className, attributes);
    }

    public boolean canLoad(final String className) {
        try {
            return LDAPDirectory.class.isAssignableFrom(Class.forName(className));
        } catch (ClassNotFoundException e) {
            logger.error("Could not load class <" + className + ">", e);
            return false;
        }
    }
}
