package com.atlassian.crowd.directory.ldap.monitoring;

import org.slf4j.Logger;
import org.springframework.ldap.core.NameClassPairCallbackHandler;

import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;

import static org.slf4j.LoggerFactory.getLogger;

/**
 * This {@link NameClassPairCallbackHandler} counts the executions and provides information about the search result's name
 * and attributes, if the {@link NameClassPair} was a {@link SearchResult}.
 * @param <T>
 */
public class ExecutionInfoNameClassPairCallbackHandler<T extends NameClassPairCallbackHandler> implements NameClassPairCallbackHandler {
    private static final Logger log = getLogger(ExecutionInfoNameClassPairCallbackHandler.class);
    private final T delegate;
    private int resultCount = 0;

    public ExecutionInfoNameClassPairCallbackHandler(T delegate) {
        this.delegate = delegate;
    }

    @Override
    public void handleNameClassPair(NameClassPair nameClassPair) throws NamingException {
        if (log.isTraceEnabled() && nameClassPair instanceof SearchResult) {
            log.trace("Search result {}, with attributes {} ", nameClassPair.getName(), ((SearchResult) nameClassPair).getAttributes());
        }
        resultCount++;
        delegate.handleNameClassPair(nameClassPair);
    }

    public void logResultCount() {
        log.debug("The operation returned {} results", resultCount);
    }

    public T getDelegate() {
        return delegate;
    }
}
