package com.atlassian.crowd.directory.ldap.mapper;

/**
 * Allows to describe what kind of attributes should be mapped during synchronisation
 *
 * @since 2.11
 */
public class UserContextMapperConfig {
    private final boolean includeAll;
    private final boolean includeMemberOf;

    private UserContextMapperConfig(boolean includeAll, boolean includeMemberOf) {
        this.includeAll = includeAll;
        this.includeMemberOf = includeMemberOf;
    }

    public boolean includeAll() {
        return includeAll;
    }

    public boolean includeMemberOf() {
        return includeMemberOf;
    }

    public static class Builder {
        private boolean includeAll = false;
        private boolean includeMemberOf = false;

        private Builder() {
        }

        /**
         * Configuration which informs that mappers from the com.atlassian.crowd.directory.ldap.mapper.entity.LDAPUserAttributesMapper#getRequiredLdapAttributes() should be used
         *
         * @return Configuration which needs required attributes
         * @see com.atlassian.crowd.directory.ldap.mapper.entity.LDAPUserAttributesMapper#getRequiredLdapAttributes()
         */
        public static Builder withRequiredAttributes() {
            return new Builder();
        }

        /**
         * Configuration specifying mappers from com.atlassian.crowd.directory.SpringLDAPConnector#getCustomUserAttributeMappers(UserContextMapperConfig)
         *
         * @return Configuration using required and custom attributes
         * @see com.atlassian.crowd.directory.SpringLDAPConnector#getCustomUserAttributeMappers(UserContextMapperConfig)
         */
        public static Builder withCustomAttributes() {
            Builder builder = new Builder();
            builder.includeAll = true;
            return builder;
        }

        /**
         * Allows set the withMemberOfAttribute mapper as necessary for the configuration
         *
         * @return Current configuration with new state
         */
        public Builder withMemberOfAttribute() {
            includeMemberOf = true;
            return this;
        }

        public UserContextMapperConfig build() {
            return new UserContextMapperConfig(includeAll, includeMemberOf);
        }
    }
}
