package com.atlassian.crowd.directory.ldap.mapper;

import com.atlassian.crowd.directory.ldap.util.DirectoryAttributeRetriever;
import com.google.common.collect.ImmutableSet;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.ldap.core.DirContextAdapter;

import java.util.Set;

/**
 * Maps the name and externalId attribute. Names of the attributes are provided in the constructor.
 */
public class NameWithExternalIdContextMapper implements ContextMapperWithRequiredAttributes<Pair<String, String>>{
    private final ExternalIdContextMapper externalIdMapper;
    private final String nameAttribute;
    private final Set<String> requiredAttributes;

    public NameWithExternalIdContextMapper(String nameAttribute, String externalIdAttribute) {
        this.externalIdMapper = new ExternalIdContextMapper(externalIdAttribute);
        this.nameAttribute = nameAttribute;
        this.requiredAttributes = ImmutableSet.of(nameAttribute, externalIdAttribute);
    }

    @Override
    public Pair<String, String> mapFromContext(Object ctx) {
        DirContextAdapter context = (DirContextAdapter) ctx;
        return Pair.of(DirectoryAttributeRetriever.getValueFromAttributes(nameAttribute, context.getAttributes()),
                externalIdMapper.mapFromContext(ctx));
    }

    @Override
    public Set<String> getRequiredLdapAttributes() {
        return requiredAttributes;
    }
}
