package com.atlassian.crowd.directory.ldap.mapper;

import com.atlassian.crowd.directory.ldap.util.DirectoryAttributeRetriever;
import org.springframework.ldap.UncategorizedLdapException;
import org.springframework.ldap.core.DirContextAdapter;

/**
 * Maps the externalId attribute. ExternalId attribute name is provided in the constructor.
 *
 * @see com.atlassian.crowd.directory.ldap.util.DirectoryAttributeRetriever#getValueFromExternalIdAttribute(String, javax.naming.directory.Attributes)
 */
public class ExternalIdContextMapper extends AttributeContextMapper<String> {
    public ExternalIdContextMapper(String propertyName) {
        super(propertyName);
    }

    /**
     * Returns objectGUID.
     *
     * @return objectGUID
     */
    @Override
    public String mapFromContext(Object ctx) {
        try {
            DirContextAdapter context = (DirContextAdapter) ctx;
            return DirectoryAttributeRetriever.getValueFromExternalIdAttribute(propertyName, context.getAttributes());
        } catch (UncategorizedLdapException e) {
            throw new RuntimeException("Could not retrieve externalId from object: " + ctx, e);
        }
    }
}
