package com.atlassian.crowd.directory.ldap.cache;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.synchronisation.cache.CacheRefresher;

/**
 * Factory for creating CacheRefresher instances.
 */
@FunctionalInterface
public interface CacheRefresherFactory {
    /**
     * Creates a new CacheRefresher instance for the given remoteDirectory.
     *
     * @param directory directory to use
     * @return new CacheRefresher instance
     */
    CacheRefresher createRefresher(RemoteDirectory directory);
}
