package com.atlassian.crowd.directory;

import javax.naming.directory.Attributes;

import com.atlassian.crowd.directory.ldap.credential.EncryptingCredentialEncoder;
import com.atlassian.crowd.directory.ldap.credential.LDAPCredentialEncoder;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotSupportedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.event.api.EventPublisher;


/**
 * This class provides read-only support for the POSIX LDAP Schema (RFC2307)
 */
public class Rfc2307 extends RFC2307Directory {
    private final PasswordEncoderFactory passwordEncoderFactory;

    public Rfc2307(LDAPQueryTranslater ldapQueryTranslater, EventPublisher eventPublisher, InstanceFactory instanceFactory, final PasswordEncoderFactory passwordEncoderFactory, LdapContextSourceProvider ldapContextSourceProvider) {
        super(ldapQueryTranslater, eventPublisher, instanceFactory, ldapContextSourceProvider);
        this.passwordEncoderFactory = passwordEncoderFactory;
    }

    public static String getStaticDirectoryType() {
        return "Generic Posix/RFC2307 Directory (Read-Only)";
    }

    @Override
    protected LDAPCredentialEncoder getCredentialEncoder() {
        return new EncryptingCredentialEncoder(passwordEncoderFactory, ldapPropertiesMapper.getUserEncryptionMethod());
    }

    @Override
    protected void getNewUserDirectorySpecificAttributes(final User user, final Attributes attributes) {
        addDefaultSnToUserAttributes(attributes, user.getName());
    }

    @Override
    public String getDescriptiveName() {
        return Rfc2307.getStaticDirectoryType();
    }

    @Override
    public void addUserToGroup(final String username, final String groupName) throws UserNotFoundException, GroupNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is read-only");
    }

    @Override
    public void addGroupToGroup(final String childGroup, final String parentGroup) throws GroupNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is read-only");
    }

    @Override
    public void removeUserFromGroup(final String username, final String groupName) throws UserNotFoundException, GroupNotFoundException, MembershipNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is read-only");
    }

    @Override
    public void removeGroupFromGroup(final String childGroup, final String parentGroup) throws GroupNotFoundException, MembershipNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is read-only");
    }

    @Override
    public LDAPUserWithAttributes addUser(final UserTemplate user, final PasswordCredential credential) throws InvalidUserException, InvalidCredentialException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is read-only");
    }

    @Override
    public LDAPUserWithAttributes addUser(final UserTemplateWithAttributes user, final PasswordCredential credential) throws InvalidUserException, InvalidCredentialException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is read-only");
    }

    @Override
    public Group addGroup(final GroupTemplate group) throws InvalidGroupException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is read-only");
    }

    @Override
    public Group renameGroup(final String oldName, final String newName) throws GroupNotFoundException, InvalidGroupException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is read-only");
    }

    @Override
    public User renameUser(final String oldName, final String newName) throws UserNotFoundException, InvalidUserException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is read-only");
    }

    @Override
    public Group updateGroup(final GroupTemplate group) throws GroupNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is read-only");
    }

    @Override
    public User updateUser(final UserTemplate user) throws UserNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is read-only");
    }

    @Override
    public void removeUser(final String name) throws UserNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is read-only");
    }

    @Override
    public void removeGroup(final String name) throws GroupNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is read-only");
    }
}