package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.ldap.credential.EncryptingCredentialEncoder;
import com.atlassian.crowd.directory.ldap.credential.LDAPCredentialEncoder;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.event.api.EventPublisher;

import javax.naming.directory.Attributes;

public class OpenLDAP extends RFC4519Directory {
    private final PasswordEncoderFactory passwordEncoderFactory;

    public OpenLDAP(LDAPQueryTranslater ldapQueryTranslater, EventPublisher eventPublisher, InstanceFactory instanceFactory,
                    final PasswordEncoderFactory passwordEncoderFactory, LdapContextSourceProvider ldapContextSourceProvider) {
        super(ldapQueryTranslater, eventPublisher, instanceFactory, ldapContextSourceProvider);
        this.passwordEncoderFactory = passwordEncoderFactory;
    }

    public static String getStaticDirectoryType() {
        return "OpenLDAP";
    }

    @Override
    public String getDescriptiveName() {
        return OpenLDAP.getStaticDirectoryType();
    }

    @Override
    protected LDAPCredentialEncoder getCredentialEncoder() {
        return new EncryptingCredentialEncoder(passwordEncoderFactory, ldapPropertiesMapper.getUserEncryptionMethod());
    }

    /**
     * OpenLDAP 2.3.35 in a default install requires the sn to be set before a user can be created.
     *
     * @param user       user
     * @param attributes directory attributes
     */
    @Override
    protected void getNewUserDirectorySpecificAttributes(final User user, final Attributes attributes) {
        addDefaultSnToUserAttributes(attributes, user.getName());
    }
}
