package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import org.springframework.ldap.core.ContextSource;

import java.util.Map;

public class LdapContextSourceProvider {
    private final LdapContextSourceFactory ldapContextSourceFactory;
    private final SpringLdapPooledContextSourceProvider springLdapPooledContextSourceProvider;
    private final SpringLdapPoolFeatureFlag springLdapPoolFeatureEnabledChecker;

    public LdapContextSourceProvider(LdapContextSourceFactory ldapContextSourceFactory, SpringLdapPooledContextSourceProvider springLdapPooledContextSourceProvider, SpringLdapPoolFeatureFlag springLdapPoolFeatureEnabledChecker) {
        this.ldapContextSourceFactory = ldapContextSourceFactory;
        this.springLdapPooledContextSourceProvider = springLdapPooledContextSourceProvider;
        this.springLdapPoolFeatureEnabledChecker = springLdapPoolFeatureEnabledChecker;
    }

    ContextSource createMinimalContextSource(final String username, final String password, final LDAPPropertiesMapper ldapPropertiesMapper, final Map<String, Object> envProperties) {
        return ldapContextSourceFactory.createMinimalContextSource(username, password, ldapPropertiesMapper, envProperties);
    }

    ContextSource getPooledContextSource(final long directoryId, final LDAPPropertiesMapper ldapPropertiesMapper, final Map<String, Object> envProperties) {
        if (springLdapPoolFeatureEnabledChecker.isEnabled()) {
            return springLdapPooledContextSourceProvider.getContextSource(directoryId, ldapPropertiesMapper, envProperties);
        }

        return ldapContextSourceFactory.createContextSource(ldapPropertiesMapper, envProperties, true);
    }

    ContextSource createContextSource(final LDAPPropertiesMapper ldapPropertiesMapper, final Map<String, Object> envProperties) {
        return ldapContextSourceFactory.createContextSource(ldapPropertiesMapper, envProperties, false);
    }
}
