package com.atlassian.crowd.directory;

import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.event.api.EventPublisher;

/**
 * Generic LDAP connector.
 */
public class GenericLDAP extends OpenLDAP {
    public GenericLDAP(LDAPQueryTranslater ldapQueryTranslater, EventPublisher eventPublisher, InstanceFactory instanceFactory,
                       PasswordEncoderFactory passwordEncoderFactory, LdapContextSourceProvider ldapContextSourceProvider) {
        super(ldapQueryTranslater, eventPublisher, instanceFactory, passwordEncoderFactory, ldapContextSourceProvider);
    }

    public static String getStaticDirectoryType() {
        return "Generic Directory Server";
    }

    @Override
    public String getDescriptiveName() {
        return GenericLDAP.getStaticDirectoryType();
    }
}
