package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.ldap.mapper.ContextMapperWithRequiredAttributes;
import org.springframework.ldap.core.DirContextAdapter;

import javax.naming.ldap.LdapName;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DeduplicatingDnMapperDecorator implements ContextMapperWithRequiredAttributes<LdapName> {
    private final ContextMapperWithRequiredAttributes<LdapName> delegate;
    private final Map<String, LdapName> mappedLdapNames = new HashMap<>();

    public DeduplicatingDnMapperDecorator(ContextMapperWithRequiredAttributes<LdapName> delegate) {
        this.delegate = delegate;
    }

    @Override
    public LdapName mapFromContext(Object ctx) {
        DirContextAdapter context = (DirContextAdapter) ctx;

        String name = context.getDn().toString();
        return mappedLdapNames.computeIfAbsent(name, k -> delegate.mapFromContext(ctx));
    }

    @Override
    public Set<String> getRequiredLdapAttributes() {
        return delegate.getRequiredLdapAttributes();
    }
}
