package com.atlassian.crowd.console.value.directory;

import com.atlassian.crowd.directory.SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth;
import com.google.common.collect.ImmutableMap;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class SyncGroupMembershipsUtils {
    private SyncGroupMembershipsUtils() {
    }

    public static Map<String, String> syncGroupMembershipsAfterAuthOptions() {
        return ImmutableMap.of(
                SyncGroupMembershipsAfterAuth.WHEN_AUTHENTICATION_CREATED_THE_USER.name(),
                "directoryconnector.update.groups.on.auth.whencreated.label",
                SyncGroupMembershipsAfterAuth.ALWAYS.name(),
                "directoryconnector.update.groups.on.auth.always.label",
                SyncGroupMembershipsAfterAuth.NEVER.name(),
                "directoryconnector.update.groups.on.auth.never.label"
        );
    }

    public static Map<String, String> syncGroupMembershipsAfterAuthOptionsNames() {
        Map<String, String> options = new HashMap<>();
        EnumSet.allOf(SyncGroupMembershipsAfterAuth.class).forEach(option -> options.put(option.name(), option.name()));
        return options;
    }
}
