package com.atlassian.crowd.console.value.directory;

import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.directory.DirectoryImpl;

public class RemoteCrowdConnection extends SynchronisableDirectoryConnection {
    private long httpTimeout = 5; // in seconds
    private long httpMaxConnections = 20;

    public long getHttpTimeout() {
        return httpTimeout;
    }

    public void setHttpTimeout(long httpTimeout) {
        this.httpTimeout = httpTimeout;
    }

    public long getHttpMaxConnections() {
        return httpMaxConnections;
    }

    public void setHttpMaxConnections(long httpMaxConnections) {
        this.httpMaxConnections = httpMaxConnections;
    }

    @Override
    public void loadFromDirectory(Directory directory) {
        super.loadFromDirectory(directory);

        final String httpTimeout = directory.getValue(RemoteCrowdDirectory.CROWD_HTTP_TIMEOUT);
        if (httpTimeout != null) {
            setHttpTimeout(Long.parseLong(httpTimeout) / 1000);
        }
        final String httpMaxConnections = directory.getValue(RemoteCrowdDirectory.CROWD_HTTP_MAX_CONNECTIONS);
        if (httpMaxConnections != null) {
            setHttpMaxConnections(Long.parseLong(httpMaxConnections));
        }
    }

    @Override
    public void updateDirectory(DirectoryImpl directory) {
        super.updateDirectory(directory);

        directory.setAttribute(RemoteCrowdDirectory.CROWD_HTTP_TIMEOUT, Long.toString(getHttpTimeout() * 1000));
        directory.setAttribute(RemoteCrowdDirectory.CROWD_HTTP_MAX_CONNECTIONS, Long.toString(getHttpMaxConnections()));
    }
}
