/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.LdapContextSourceFactory;
import com.atlassian.crowd.directory.SpringLdapPoolFeatureFlag;
import com.atlassian.crowd.directory.SpringLdapPooledContextSourceProvider;
import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import java.util.Map;
import org.springframework.ldap.core.ContextSource;

public class LdapContextSourceProvider {
    private final LdapContextSourceFactory ldapContextSourceFactory;
    private final SpringLdapPooledContextSourceProvider springLdapPooledContextSourceProvider;
    private final SpringLdapPoolFeatureFlag springLdapPoolFeatureEnabledChecker;

    public LdapContextSourceProvider(LdapContextSourceFactory ldapContextSourceFactory, SpringLdapPooledContextSourceProvider springLdapPooledContextSourceProvider, SpringLdapPoolFeatureFlag springLdapPoolFeatureEnabledChecker) {
        this.ldapContextSourceFactory = ldapContextSourceFactory;
        this.springLdapPooledContextSourceProvider = springLdapPooledContextSourceProvider;
        this.springLdapPoolFeatureEnabledChecker = springLdapPoolFeatureEnabledChecker;
    }

    ContextSource createMinimalContextSource(String username, String password, LDAPPropertiesMapper ldapPropertiesMapper, Map<String, Object> envProperties) {
        return this.ldapContextSourceFactory.createMinimalContextSource(username, password, ldapPropertiesMapper, envProperties);
    }

    ContextSource getPooledContextSource(long directoryId, LDAPPropertiesMapper ldapPropertiesMapper, Map<String, Object> envProperties) {
        if (this.springLdapPoolFeatureEnabledChecker.isEnabled()) {
            return this.springLdapPooledContextSourceProvider.getContextSource(directoryId, ldapPropertiesMapper, envProperties);
        }
        return this.ldapContextSourceFactory.createContextSource(ldapPropertiesMapper, envProperties, true);
    }

    ContextSource createContextSource(LDAPPropertiesMapper ldapPropertiesMapper, Map<String, Object> envProperties) {
        return this.ldapContextSourceFactory.createContextSource(ldapPropertiesMapper, envProperties, false);
    }
}

