/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.common.properties.SpringLdapPoolProperties;
import com.atlassian.crowd.directory.SpringLDAPConnector;
import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.directory.ldap.LdapSecureMode;
import com.atlassian.crowd.directory.ssl.CrowdTlsDirContextAuthenticationStrategy;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.naming.directory.DirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.DirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.pool2.DirContextType;
import org.springframework.ldap.pool2.factory.PoolConfig;
import org.springframework.ldap.pool2.factory.PooledContextSource;
import org.springframework.ldap.pool2.validation.DefaultDirContextValidator;
import org.springframework.ldap.pool2.validation.DirContextValidator;

public class LdapContextSourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(LdapContextSourceFactory.class);
    private final Supplier<LdapContextSource> ldapContextSourceSupplier;

    public LdapContextSourceFactory() {
        this.ldapContextSourceSupplier = LdapContextSource::new;
    }

    @VisibleForTesting
    LdapContextSourceFactory(Supplier<LdapContextSource> ldapContextSourceSupplier) {
        this.ldapContextSourceSupplier = ldapContextSourceSupplier;
    }

    ContextSource createMinimalContextSource(String username, String password, LDAPPropertiesMapper ldapPropertiesMapper, Map<String, Object> envProperties) {
        LdapContextSource contextSource = this.ldapContextSourceSupplier.get();
        contextSource.setUrl(ldapPropertiesMapper.getConnectionURL());
        contextSource.setUserDn(username);
        contextSource.setPassword(password);
        contextSource.setBaseEnvironmentProperties(envProperties);
        contextSource.setPooled(false);
        this.maybeApplyTls(ldapPropertiesMapper, contextSource);
        contextSource.afterPropertiesSet();
        return contextSource;
    }

    ContextSource createContextSource(LDAPPropertiesMapper ldapPropertiesMapper, Map<String, Object> envProperties, boolean useLegacyPooling) {
        LdapContextSource contextSource = this.ldapContextSourceSupplier.get();
        String initialContextFactoryClassName = (String)envProperties.get("java.naming.factory.initial");
        if (initialContextFactoryClassName != null) {
            try {
                contextSource.setContextFactory(Class.forName(initialContextFactoryClassName, false, SpringLDAPConnector.class.getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                NoClassDefFoundError err = new NoClassDefFoundError(initialContextFactoryClassName);
                err.initCause(e);
                throw err;
            }
        }
        contextSource.setUrl(ldapPropertiesMapper.getConnectionURL());
        contextSource.setUserDn(ldapPropertiesMapper.getUsername());
        contextSource.setPassword(ldapPropertiesMapper.getPassword());
        contextSource.setBaseEnvironmentProperties(envProperties);
        boolean tlsApplied = this.maybeApplyTls(ldapPropertiesMapper, contextSource);
        contextSource.setPooled(useLegacyPooling && !tlsApplied);
        try {
            contextSource.afterPropertiesSet();
        }
        catch (Exception e) {
            logger.error("Failed to configure context source", (Throwable)e);
        }
        return contextSource;
    }

    boolean areConnectionPropertiesSame(LDAPPropertiesMapper left, LDAPPropertiesMapper right) {
        return Stream.of(LDAPPropertiesMapper::getConnectionURL, LDAPPropertiesMapper::getUsername, LDAPPropertiesMapper::getPassword, LDAPPropertiesMapper::getSecureMode).allMatch(getter -> Objects.equals(getter.apply(left), getter.apply(right)));
    }

    private boolean maybeApplyTls(LDAPPropertiesMapper ldapPropertiesMapper, LdapContextSource ldapContextSource) {
        if (ldapPropertiesMapper.getSecureMode() == LdapSecureMode.START_TLS) {
            ldapContextSource.setAuthenticationStrategy((DirContextAuthenticationStrategy)new CrowdTlsDirContextAuthenticationStrategy());
            return true;
        }
        return false;
    }

    PooledContextSource createPooledContextSource(long directoryId, LDAPPropertiesMapper ldapPropertiesMapper, Map<String, Object> envProperties) {
        ContextSource contextSource = this.createContextSource(ldapPropertiesMapper, envProperties, false);
        PoolConfig poolConfig = new PoolConfig();
        poolConfig.setBlockWhenExhausted(SpringLdapPoolProperties.BLOCK_WHEN_EXHAUSTED.getValue().booleanValue());
        poolConfig.setEvictionPolicyClassName(SpringLdapPoolProperties.EVICTION_POLICY_CLASS.getValue());
        poolConfig.setFairness(SpringLdapPoolProperties.FAIRNESS.getValue().booleanValue());
        poolConfig.setJmxEnabled(SpringLdapPoolProperties.JMX_ENABLE.getValue().booleanValue());
        poolConfig.setJmxNamePrefix(String.format("%s-directory-%d  ", SpringLdapPoolProperties.JMX_NAME_PREFIX.getValue(), directoryId));
        poolConfig.setLifo(SpringLdapPoolProperties.LIFO.getValue().booleanValue());
        poolConfig.setMaxIdlePerKey(SpringLdapPoolProperties.MAX_IDLE_PER_KEY.getValue().intValue());
        poolConfig.setMaxTotal(SpringLdapPoolProperties.MAX_TOTAL.getValue().intValue());
        poolConfig.setMaxTotalPerKey(SpringLdapPoolProperties.MAX_TOTAL_PER_KEY.getValue().intValue());
        poolConfig.setMaxWaitMillis((long)SpringLdapPoolProperties.MAX_WAIT.getValue().intValue());
        poolConfig.setMinEvictableIdleTimeMillis((long)SpringLdapPoolProperties.MIN_EVICTABLE_TIME_MILLIS.getValue().intValue());
        poolConfig.setSoftMinEvictableIdleTimeMillis((long)SpringLdapPoolProperties.SOFT_MIN_EVICTABLE_TIME_MILLIS.getValue().intValue());
        poolConfig.setNumTestsPerEvictionRun(SpringLdapPoolProperties.TESTS_PER_EVICTION_RUN.getValue().intValue());
        poolConfig.setTimeBetweenEvictionRunsMillis((long)SpringLdapPoolProperties.EVICTION_RUN_INTERVAL_MILLIS.getValue().intValue());
        poolConfig.setTestOnBorrow(SpringLdapPoolProperties.TEST_ON_BORROW.getValue().booleanValue());
        poolConfig.setTestOnCreate(SpringLdapPoolProperties.TEST_ON_CREATE.getValue().booleanValue());
        poolConfig.setTestOnReturn(SpringLdapPoolProperties.TEST_ON_RETURN.getValue().booleanValue());
        poolConfig.setTestWhileIdle(SpringLdapPoolProperties.TEST_WHILE_IDLE.getValue().booleanValue());
        poolConfig.setMinIdlePerKey(SpringLdapPoolProperties.MIN_IDLE_PER_KEY.getValue().intValue());
        CrowdPooledContextSource poolingContextSource = new CrowdPooledContextSource(poolConfig);
        poolingContextSource.setContextSource(contextSource);
        poolingContextSource.setDirContextValidator((DirContextValidator)new DefaultDirContextValidator());
        return poolingContextSource;
    }

    @VisibleForTesting
    static class CrowdPooledContextSource
    extends PooledContextSource {
        CrowdPooledContextSource(PoolConfig poolConfig) {
            super(poolConfig);
        }

        protected DirContext getContext(DirContextType dirContextType) {
            try {
                return super.getContext(dirContextType);
            }
            catch (DataAccessResourceFailureException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw e;
            }
        }
    }
}

