/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.cache;

import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.RFC4519DirectoryMembershipsIterable;
import com.atlassian.crowd.directory.ldap.cache.AbstractCacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.directory.ldap.cache.LDAPEntityNameMap;
import com.atlassian.crowd.directory.ldap.cache.UsnChangedCacheRefresherIncSyncException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.Tombstone;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.fugue.Pair;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsnChangedCacheRefresher
extends AbstractCacheRefresher
implements CacheRefresher {
    private static final Logger log = LoggerFactory.getLogger(UsnChangedCacheRefresher.class);
    private static final long UNINITIALISED = -1L;
    public static final Function<Tombstone, String> TOMBSTONE_TO_GUID_FUNCTION = new Function<Tombstone, String>(){

        public String apply(Tombstone tombstone) {
            return tombstone.getObjectGUID();
        }
    };
    public static final String PROPERTY_USE_LEGACY_AD_INCREMENTAL_SYNC = "crowd.use.legacy.ad.incremental.sync";
    private final MicrosoftActiveDirectory activeDirectory;
    private volatile long highestCommittedUSN = -1L;
    final LDAPEntityNameMap<LDAPUserWithAttributes> userMap = new LDAPEntityNameMap();
    private final LDAPEntityNameMap<LDAPGroupWithAttributes> groupMap = new LDAPEntityNameMap();
    private Future<List<LDAPUserWithAttributes>> userListFuture;
    private Future<List<LDAPGroupWithAttributes>> groupListFuture;
    private final boolean useLegacyADIncrementalSync = Boolean.valueOf(System.getProperty("crowd.use.legacy.ad.incremental.sync", "false"));

    public UsnChangedCacheRefresher(MicrosoftActiveDirectory activeDirectory) {
        super(activeDirectory);
        this.activeDirectory = activeDirectory;
    }

    @Override
    public boolean synchroniseChanges(DirectoryCache directoryCache) throws OperationFailedException {
        if (!this.isIncrementalSyncEnabled()) {
            return false;
        }
        if (this.highestCommittedUSN == -1L) {
            log.info("A full sync of directory [{}] is necessary before incremental sync is possible.", (Object)this.activeDirectory.getDirectoryId());
            return false;
        }
        if (this.getCqlUserFilter() != null) {
            throw new OperationFailedException("Incremental sync with a configured CQL user filter is not supported");
        }
        long currentHighestCommittedUSN = this.activeDirectory.fetchHighestCommittedUSN();
        this.synchroniseUserChanges(directoryCache);
        this.synchroniseGroupChanges(directoryCache);
        this.highestCommittedUSN = currentHighestCommittedUSN;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchroniseAll(DirectoryCache directoryCache) throws OperationFailedException {
        ExecutorService queryExecutor = Executors.newFixedThreadPool(3, ThreadFactories.namedThreadFactory((String)"CrowdUsnChangedCacheRefresher"));
        try {
            this.userListFuture = queryExecutor.submit(new Callable<List<LDAPUserWithAttributes>>(){

                @Override
                public List<LDAPUserWithAttributes> call() throws Exception {
                    long start = System.currentTimeMillis();
                    log.debug("loading remote users");
                    List<LDAPUserWithAttributes> ldapUsers = UsnChangedCacheRefresher.this.activeDirectory.searchUsers(QueryBuilder.queryFor(LDAPUserWithAttributes.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
                    log.info("found [ " + ldapUsers.size() + " ] remote users in [ " + (System.currentTimeMillis() - start) + "ms ]");
                    return ldapUsers;
                }
            });
            this.groupListFuture = queryExecutor.submit(new Callable<List<LDAPGroupWithAttributes>>(){

                @Override
                public List<LDAPGroupWithAttributes> call() throws Exception {
                    long start = System.currentTimeMillis();
                    log.debug("loading remote groups");
                    List<LDAPGroupWithAttributes> ldapGroups = UsnChangedCacheRefresher.this.activeDirectory.searchGroups(QueryBuilder.queryFor(LDAPGroupWithAttributes.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1));
                    log.info("found [ " + ldapGroups.size() + " ] remote groups in [ " + (System.currentTimeMillis() - start) + "ms ]");
                    return ldapGroups;
                }
            });
            long currentHighestCommittedUSN = this.activeDirectory.fetchHighestCommittedUSN();
            super.synchroniseAll(directoryCache);
            this.highestCommittedUSN = currentHighestCommittedUSN;
        }
        finally {
            queryExecutor.shutdown();
            this.userListFuture = null;
            this.groupListFuture = null;
        }
    }

    @Override
    protected void synchroniseAllUsers(DirectoryCache directoryCache) throws OperationFailedException {
        this.userMap.clear();
        Date syncStartDate = new Date();
        try {
            List<LDAPUserWithAttributes> ldapUsers = this.userListFuture.get();
            this.userMap.putAll(ldapUsers);
            directoryCache.deleteCachedUsersNotIn(ldapUsers, syncStartDate);
            directoryCache.addOrUpdateCachedUsers(ldapUsers, syncStartDate);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationFailedException("background query interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    protected List<? extends Group> synchroniseAllGroups(DirectoryCache directoryCache) throws OperationFailedException {
        this.groupMap.clear();
        Date syncStartDate = new Date();
        try {
            List<LDAPGroupWithAttributes> ldapGroups = this.groupListFuture.get();
            ldapGroups = Collections.unmodifiableList(UsnChangedCacheRefresher.filterOutDuplicateGroups(ldapGroups));
            this.groupMap.putAll(ldapGroups);
            directoryCache.deleteCachedGroupsNotIn(GroupType.GROUP, ldapGroups, syncStartDate);
            directoryCache.addOrUpdateCachedGroups(ldapGroups, syncStartDate);
            return ldapGroups;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationFailedException("background query interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private void synchroniseUserChangesUsn(DirectoryCache directoryCache) throws OperationFailedException {
        long start = System.currentTimeMillis();
        log.debug("loading changed remote users");
        List<LDAPUserWithAttributes> updatedUsers = this.activeDirectory.findAddedOrUpdatedUsersSince(this.highestCommittedUSN);
        List<Tombstone> tombstones = this.activeDirectory.findUserTombstonesSince(this.highestCommittedUSN);
        this.userMap.putAll(updatedUsers);
        log.info("found [ {} ] changed remote users in [ {}ms ]", (Object)(updatedUsers.size() + tombstones.size()), (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        ImmutableSet tombstonesGuids = ImmutableSet.copyOf((Iterable)Iterables.transform(tombstones, TOMBSTONE_TO_GUID_FUNCTION));
        log.info("scanned and compared [ {} ] users for delete in DB cache in [ {}ms ]", (Object)tombstones.size(), (Object)(System.currentTimeMillis() - start));
        directoryCache.deleteCachedUsersByGuid((Set<String>)tombstonesGuids);
        this.userMap.removeAllByGuid((Collection<String>)tombstonesGuids);
        directoryCache.addOrUpdateCachedUsers(updatedUsers, null);
    }

    private Pair<? extends Set<String>, ? extends Set<String>> validateAndReturnGuidsToAddAndDelete(DirectoryCache directoryCache) throws OperationFailedException {
        if (!this.activeDirectory.isExternalIdConfigured()) {
            throw new UsnChangedCacheRefresherIncSyncException("externalId attribute is not configured in directory.");
        }
        log.debug("loading changed users");
        ImmutableSet guidsInCache = ImmutableSet.copyOf(directoryCache.getAllUserGuids());
        if ((long)guidsInCache.size() != directoryCache.getUserCount()) {
            throw new UsnChangedCacheRefresherIncSyncException("Cache returned different number of guids and users (possible reason is overlapping guids in cache, most likely null/empty values).");
        }
        if (guidsInCache.contains("")) {
            throw new UsnChangedCacheRefresherIncSyncException("Empty guids returned from cache. Falling back to a full sync in order to populate the guids");
        }
        Set<String> guidsInAD = this.activeDirectory.findAllUserGuids();
        if (guidsInAD.contains("")) {
            throw new UsnChangedCacheRefresherIncSyncException("Empty guids returned from AD. Possible reasons are externalId attribute value in directory configuration or AD server configuration.");
        }
        return Pair.pair((Object)Sets.difference(guidsInAD, (Set)guidsInCache), (Object)Sets.difference((Set)guidsInCache, guidsInAD));
    }

    private void synchroniseUserChangesGuid(DirectoryCache directoryCache) throws OperationFailedException {
        long start = System.currentTimeMillis();
        Pair<? extends Set<String>, ? extends Set<String>> guidsToAddAndRemove = this.validateAndReturnGuidsToAddAndDelete(directoryCache);
        Set guidsToAdd = (Set)guidsToAddAndRemove.left();
        Set guidsToRemove = (Set)guidsToAddAndRemove.right();
        ImmutableMap.Builder usersToAddByGuidBuilder = ImmutableMap.builder();
        ImmutableList.Builder usersToUpdateBuilder = ImmutableList.builder();
        for (LDAPUserWithAttributes user : this.activeDirectory.findAddedOrUpdatedUsersSince(this.highestCommittedUSN)) {
            String externalId = user.getExternalId();
            if (StringUtils.isEmpty((CharSequence)externalId)) {
                throw new UsnChangedCacheRefresherIncSyncException("A null or empty guid retrieved from AD.");
            }
            if (guidsToAdd.contains(externalId)) {
                usersToAddByGuidBuilder.put((Object)externalId, (Object)user);
                continue;
            }
            usersToUpdateBuilder.add((Object)user);
        }
        ImmutableMap usersToAddByGuid = usersToAddByGuidBuilder.build();
        ImmutableList usersToUpdate = usersToUpdateBuilder.build();
        log.info("scanned and compared [ {} ] users to delete, [ {} ] users to add, [ {} ] users to update in DB cache in [ {}ms ]", new Object[]{guidsToRemove.size(), guidsToAdd.size(), usersToUpdate.size(), System.currentTimeMillis() - start});
        directoryCache.deleteCachedUsersByGuid(guidsToRemove);
        this.userMap.removeAllByGuid(guidsToRemove);
        directoryCache.addOrUpdateCachedUsers((List<? extends User>)usersToUpdate, null);
        this.userMap.putAll((Collection<LDAPUserWithAttributes>)usersToUpdate);
        ArrayList newUsers = Lists.newArrayList((Iterable)Iterables.transform((Iterable)guidsToAdd, this.getGuidToUserFunction((Map<String, LDAPUserWithAttributes>)usersToAddByGuid)));
        directoryCache.addOrUpdateCachedUsers(newUsers, null);
        this.userMap.putAll(newUsers);
    }

    void synchroniseUserChanges(DirectoryCache directoryCache) throws OperationFailedException {
        if (this.useLegacyADIncrementalSync) {
            this.synchroniseUserChangesUsn(directoryCache);
        } else {
            this.synchroniseUserChangesGuid(directoryCache);
        }
    }

    private void synchroniseGroupChanges(DirectoryCache directoryCache) throws OperationFailedException {
        long start = System.currentTimeMillis();
        log.debug("loading changed remote groups");
        List<LDAPGroupWithAttributes> updatedGroups = UsnChangedCacheRefresher.filterOutDuplicateGroups(this.activeDirectory.findAddedOrUpdatedGroupsSince(this.highestCommittedUSN));
        List<Tombstone> tombstones = this.activeDirectory.findGroupTombstonesSince(this.highestCommittedUSN);
        log.info("found [ " + (updatedGroups.size() + tombstones.size()) + " ] changed remote groups in [ " + (System.currentTimeMillis() - start) + "ms ]");
        this.groupMap.putAll(updatedGroups);
        directoryCache.addOrUpdateCachedGroups(updatedGroups, null);
        this.synchroniseMemberships(updatedGroups, directoryCache);
        start = System.currentTimeMillis();
        HashSet<String> groupnames = new HashSet<String>();
        for (Tombstone tombstone : tombstones) {
            String groupName = this.groupMap.getByGuid(tombstone.getObjectGUID());
            if (groupName == null) continue;
            groupnames.add(groupName);
        }
        log.info("scanned and compared [ " + tombstones.size() + " ] groups for delete in DB cache in [ " + (System.currentTimeMillis() - start) + "ms ]");
        directoryCache.deleteCachedGroups(groupnames);
    }

    @Override
    Iterable<Membership> getMemberships(Iterable<String> names) throws OperationFailedException {
        try {
            Map<LdapName, String> users = this.userMap.toLdapNameKeyedMap();
            Map<LdapName, String> groups = this.groupMap.toLdapNameKeyedMap();
            return new RFC4519DirectoryMembershipsIterable(this.activeDirectory, users, groups, (Set<String>)ImmutableSet.copyOf(names));
        }
        catch (InvalidNameException e) {
            throw new OperationFailedException("Failed to get directory memberships due to invalid DN", (Throwable)e);
        }
    }

    private Function<String, LDAPUserWithAttributes> getGuidToUserFunction(Map<String, LDAPUserWithAttributes> userCache) {
        return new GuidToUserFunction(this.activeDirectory, userCache);
    }

    static class GuidToUserFunction
    implements Function<String, LDAPUserWithAttributes> {
        private final MicrosoftActiveDirectory activeDirectory;
        private final Map<String, LDAPUserWithAttributes> userCache;

        GuidToUserFunction(MicrosoftActiveDirectory activeDirectory, Map<String, LDAPUserWithAttributes> userCache) {
            this.activeDirectory = activeDirectory;
            this.userCache = userCache;
        }

        public LDAPUserWithAttributes apply(String externalId) {
            try {
                LDAPUserWithAttributes userFromCache = this.userCache.get(externalId);
                if (userFromCache != null) {
                    return userFromCache;
                }
                return this.activeDirectory.findUserByExternalId(externalId);
            }
            catch (UserNotFoundException e) {
                log.warn("User with objectGUID '{}' not found in ActiveDirectory", (Object)externalId);
            }
            catch (OperationFailedException e) {
                log.warn("Failed to fetch user by objectGUID '{}' from ActiveDirectory", (Object)externalId, (Object)e);
            }
            throw new UsnChangedCacheRefresherIncSyncException("Problems while looking up users by objectGUID in ActiveDirectory detected, falling back to a full sync.");
        }
    }
}

