/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap;

import com.atlassian.crowd.directory.LimitedNamingEnumeration;
import com.atlassian.crowd.directory.ldap.mapper.ContextMapperWithRequiredAttributes;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextMapperCallbackHandler;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.NameClassPairCallbackHandler;
import org.springframework.ldap.core.SearchExecutor;

public class SpringLdapTemplateWrapper {
    private static final String TIMED_LOG_THRESHOLD_MILLIS = "com.atlassian.crowd.ldap.log.wait.threshold";
    private static final long DEFAULT_TIMED_LOG_THRESHOLD_MILLIS = 1000L;
    private static final Logger logger = LoggerFactory.getLogger(SpringLdapTemplateWrapper.class);
    private final LdapTemplate template;
    private final long logThreshold;

    public SpringLdapTemplateWrapper(LdapTemplate template) {
        this.template = template;
        this.logThreshold = SpringLdapTemplateWrapper.getLogThreshold();
    }

    private static long getLogThreshold() {
        String thresholdString = System.getProperty(TIMED_LOG_THRESHOLD_MILLIS);
        if (thresholdString == null) {
            return 1000L;
        }
        try {
            return Long.parseLong(thresholdString);
        }
        catch (NumberFormatException e) {
            logger.warn("Could not parse 'com.atlassian.crowd.ldap.log.wait.threshold'. Using default of 1s.");
            return 1000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T invokeWithContextClassLoader(CallableWithoutCheckedException<T> runnable) {
        Thread current = Thread.currentThread();
        ClassLoader orig = current.getContextClassLoader();
        try {
            ClassLoader classLoaderForThisClass = SpringLdapTemplateWrapper.class.getClassLoader();
            current.setContextClassLoader(classLoaderForThisClass);
            T t = runnable.call();
            return t;
        }
        finally {
            current.setContextClassLoader(orig);
        }
    }

    public List search(final Name base, final String filter, final SearchControls controls, final ContextMapper mapper) {
        return SpringLdapTemplateWrapper.invokeWithContextClassLoader(new TimedCallable<List>(this.logThreshold){

            @Override
            public List timedCall() {
                return SpringLdapTemplateWrapper.this.template.search(base, filter, controls, mapper);
            }

            @Override
            public String message() {
                return "search on " + base;
            }
        });
    }

    public List search(final Name base, final String filter, final SearchControls controls, final ContextMapper mapper, final DirContextProcessor processor) {
        return SpringLdapTemplateWrapper.invokeWithContextClassLoader(new TimedCallable<List>(this.logThreshold){

            @Override
            public List timedCall() {
                return SpringLdapTemplateWrapper.this.template.search(base, filter, controls, mapper, processor);
            }

            @Override
            public String message() {
                return "search with dircontext on " + base;
            }
        });
    }

    public Object lookup(final Name dn) {
        return SpringLdapTemplateWrapper.invokeWithContextClassLoader(new TimedCallable<Object>(this.logThreshold){

            @Override
            public Object timedCall() {
                return SpringLdapTemplateWrapper.this.template.lookup(dn);
            }

            @Override
            public String message() {
                return "lookup on " + dn;
            }
        });
    }

    public void search(final Name base, final String filter, final SearchControls controls, final NameClassPairCallbackHandler handler, final DirContextProcessor processor) {
        SpringLdapTemplateWrapper.invokeWithContextClassLoader(new TimedCallable<Object>(this.logThreshold){

            @Override
            public Void timedCall() {
                SpringLdapTemplateWrapper.this.template.search(base, filter, controls, handler, processor);
                return null;
            }

            @Override
            public String message() {
                return "search with handler on " + base;
            }
        });
    }

    public void unbind(final Name dn) {
        SpringLdapTemplateWrapper.invokeWithContextClassLoader(new TimedCallable<Object>(this.logThreshold){

            @Override
            public Void timedCall() {
                SpringLdapTemplateWrapper.this.template.unbind(dn);
                return null;
            }

            @Override
            public String message() {
                return "unbind on " + dn;
            }
        });
    }

    public void bind(final Name dn, final Object obj, final Attributes attributes) {
        SpringLdapTemplateWrapper.invokeWithContextClassLoader(new TimedCallable<Object>(this.logThreshold){

            @Override
            public Void timedCall() {
                SpringLdapTemplateWrapper.this.template.bind(dn, obj, attributes);
                return null;
            }

            @Override
            public String message() {
                return "bind on " + dn;
            }
        });
    }

    public void modifyAttributes(final Name dn, final ModificationItem[] mods) {
        SpringLdapTemplateWrapper.invokeWithContextClassLoader(new TimedCallable<Object>(this.logThreshold){

            @Override
            public Void timedCall() {
                SpringLdapTemplateWrapper.this.template.modifyAttributes(dn, mods);
                return null;
            }

            @Override
            public String message() {
                return "modify attributes on " + dn;
            }
        });
    }

    public void lookup(final LdapName dn, final String[] attributes, final AttributesMapper mapper) {
        SpringLdapTemplateWrapper.invokeWithContextClassLoader(new TimedCallable<Object>(this.logThreshold){

            @Override
            public Void timedCall() {
                SpringLdapTemplateWrapper.this.template.lookup((Name)dn, attributes, mapper);
                return null;
            }

            @Override
            public String message() {
                return "lookup on " + dn;
            }
        });
    }

    public <T> T lookup(final LdapName dn, final ContextMapperWithRequiredAttributes<T> mapper) {
        Set<String> attrSet = mapper.getRequiredLdapAttributes();
        final String[] attributes = attrSet.toArray(new String[attrSet.size()]);
        return SpringLdapTemplateWrapper.invokeWithContextClassLoader(new TimedCallable<T>(this.logThreshold){

            @Override
            public T timedCall() {
                return SpringLdapTemplateWrapper.this.template.lookup((Name)dn, attributes, (ContextMapper)mapper);
            }

            @Override
            public String message() {
                return "lookup with mapper on " + dn;
            }
        });
    }

    public void setIgnorePartialResultException(boolean ignore) {
        this.template.setIgnorePartialResultException(ignore);
    }

    public void search(final SearchExecutor se, final NameClassPairCallbackHandler handler, final DirContextProcessor processor) {
        SpringLdapTemplateWrapper.invokeWithContextClassLoader(new TimedCallable<Object>(this.logThreshold){

            @Override
            public Void timedCall() {
                SpringLdapTemplateWrapper.this.template.search(se, handler, processor);
                return null;
            }

            @Override
            public String message() {
                return "search using searchexecutor " + se;
            }
        });
    }

    public List searchWithLimitedResults(final Name baseDN, final String filter, final SearchControls searchControls, ContextMapper contextMapper, DirContextProcessor processor, final int limit) {
        SearchExecutor se = new SearchExecutor(){

            public NamingEnumeration<SearchResult> executeSearch(DirContext ctx) throws NamingException {
                NamingEnumeration<SearchResult> ne = ctx.search(baseDN, filter, searchControls);
                if (limit != -1) {
                    return new LimitedNamingEnumeration<SearchResult>(ne, limit);
                }
                return ne;
            }
        };
        ContextMapperCallbackHandler handler = new ContextMapperCallbackHandler(contextMapper);
        this.search(se, (NameClassPairCallbackHandler)handler, processor);
        return handler.getList();
    }

    static interface CallableWithoutCheckedException<T> {
        public T call();
    }

    @VisibleForTesting
    static abstract class TimedCallable<T>
    implements CallableWithoutCheckedException<T> {
        private final Logger log;
        private final Stopwatch watch;
        private final long thresholdMillis;

        public TimedCallable(long timedThreshold) {
            this(new Stopwatch(), logger, timedThreshold);
        }

        public TimedCallable(Stopwatch watch, Logger log, long thresholdMillis) {
            this.watch = watch;
            this.log = log;
            this.thresholdMillis = thresholdMillis;
        }

        public abstract T timedCall();

        public abstract String message();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T call() {
            this.watch.start();
            try {
                T t = this.timedCall();
                return t;
            }
            finally {
                this.watch.stop();
                if (this.watch.elapsedMillis() > this.thresholdMillis) {
                    this.log.info("Timed call for {} took {}ms", (Object)this.message(), (Object)this.watch.elapsedMillis());
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("Timed call for {} took {}ms", (Object)this.message(), (Object)this.watch.elapsedMillis());
                }
            }
        }
    }
}

