/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.cache;

import com.atlassian.crowd.cql.parser.CqlQueryParser;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.cache.AbstractCacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.PropertyTypeService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDirectoryCacheRefresher
extends AbstractCacheRefresher
implements CacheRefresher {
    private static final Logger log = LoggerFactory.getLogger(RemoteDirectoryCacheRefresher.class);
    public static final EntityQuery<GroupWithAttributes> ALL_REMOTE_GROUPS_QUERY = QueryBuilder.queryFor(GroupWithAttributes.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1);
    private final CqlQueryParser cqlQueryParser;
    private final PropertyTypeService userPropertyTypeService;

    public RemoteDirectoryCacheRefresher(RemoteDirectory remoteDirectory, CqlQueryParser cqlQueryParser, PropertyTypeService userPropertyTypeService) {
        super(remoteDirectory);
        this.cqlQueryParser = cqlQueryParser;
        this.userPropertyTypeService = userPropertyTypeService;
    }

    @Override
    public boolean synchroniseChanges(DirectoryCache directoryCache) throws OperationFailedException {
        return false;
    }

    private List<User> findAllRemoteUsers() throws OperationFailedException {
        long start = System.currentTimeMillis();
        log.debug("loading remote users");
        List users = this.remoteDirectory.searchUsers(this.getUserQuery());
        log.info("found [ {} ] remote users in [ {} ms ]", (Object)users.size(), (Object)(System.currentTimeMillis() - start));
        return users;
    }

    private EntityQuery<User> getUserQuery() {
        QueryBuilder.PartialEntityQuery partialQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user());
        String cqlUserFilter = this.getCqlUserFilter();
        if (cqlUserFilter == null) {
            return partialQuery.returningAtMost(-1);
        }
        log.debug("Only loading remote users who match CQL filter {}", (Object)cqlUserFilter);
        SearchRestriction restriction = this.cqlQueryParser.parseQuery(cqlUserFilter, this.userPropertyTypeService);
        return partialQuery.with(restriction).returningAtMost(-1);
    }

    private List<GroupWithAttributes> findAllRemoteGroups() throws OperationFailedException {
        long start = System.currentTimeMillis();
        log.debug("loading remote groups");
        List groups = this.remoteDirectory.searchGroups(ALL_REMOTE_GROUPS_QUERY);
        log.info("found [ {} ] remote groups in [ {} ms ]", (Object)groups.size(), (Object)(System.currentTimeMillis() - start));
        return groups;
    }

    @Override
    protected void synchroniseAllUsers(DirectoryCache directoryCache) throws OperationFailedException {
        Date syncStartDate = new Date();
        List<User> ldapUsers = this.findAllRemoteUsers();
        directoryCache.deleteCachedUsersNotIn(ldapUsers, syncStartDate);
        directoryCache.addOrUpdateCachedUsers(ldapUsers, syncStartDate);
    }

    @Override
    protected List<? extends Group> synchroniseAllGroups(DirectoryCache directoryCache) throws OperationFailedException {
        Date syncStartDate = new Date();
        List<GroupWithAttributes> groups = RemoteDirectoryCacheRefresher.filterOutDuplicateGroups(this.findAllRemoteGroups());
        directoryCache.addOrUpdateCachedGroups(groups, syncStartDate);
        directoryCache.deleteCachedGroupsNotIn(GroupType.GROUP, groups, syncStartDate);
        return groups;
    }
}

